<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SitemapController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [HomeController::class, 'home'])->name('homepage');  
Route::get('/contact-us', [HomeController::class, 'contactus'])->name('contactus');
Route::get('/behind-the-story', [HomeController::class, 'aboutus'])->name('aboutus');
Route::get('/rent-vehicle', [HomeController::class, 'rent'])->name('rent');
Route::get('/packages', [HomeController::class, 'packages'])->name('packages');
Route::get('/package-detail', [HomeController::class, 'package_detail'])->name('package_detail');
Route::get('/payment', [HomeController::class, 'payment'])->name('payment');

Route::get('/aliya', [HomeController::class, 'aliya'])->name('aliya');
Route::get('araliya', [HomeController::class, 'araliyanew'])->name('araliyanew');
Route::get('/green-escapes', [HomeController::class, 'green_escapes'])->name('green_escapes');
Route::get('/hop-on', [HomeController::class, 'hop_on'])->name('hop_on');
Route::get('/luxe-looks', [HomeController::class, 'luxe_looks'])->name('luxe_looks');
Route::get('/royal-route', [HomeController::class, 'royal_route'])->name('royal_route');
Route::get('/trendy-treasures', [HomeController::class, 'trendy_treasures'])->name('trendy_treasures');
Route::get('/wander-rush', [HomeController::class, 'wander_rush'])->name('wander_rush');

Route::post('/order', [HomeController::class, 'order'])->name('order');
Route::POST('/paymentRedirect', [HomeController::class, 'paymentRedirect'])->name('paymentRedirect');

Route::get('/yala-safari', [HomeController::class, 'yala_safari'])->name('yala');

Route::get('/minneriya-safari', [HomeController::class, 'minneriya_safari'])->name('minneriya');
Route::get('/udawalawa-safari', [HomeController::class, 'udawalawa_safari'])->name('udawalawa');
Route::get('/wilpatthu-safari', [HomeController::class, 'wilpatthu_safari'])->name('wilpatthu');
Route::get('/bandula-safari', [HomeController::class, 'bandula_safari'])->name('bandula');
Route::get('/mirissa-and-trincomalee-whale-watching', [HomeController::class, 'mirissa'])->name('mirissa');
Route::get('/tincomalee ', [HomeController::class, 'trinco'])->name('trinco');

Route::get('/ticket-price', [HomeController::class, 'ticket_price'])->name('ticket-price');
Route::get('/railway-ticket', [HomeController::class, 'railway_ticket'])->name('railway_ticket');
Route::get('/hotel-reservations', [HomeController::class, 'hotels'])->name('hotels');
Route::post('/booking', [HomeController::class, 'booking'])->name('booking');
Route::match(['get', 'post'],'/quotation', [HomeController::class, 'quotation'])->name('quotation');
Route::post('/sendmail', [HomeController::class, 'sendmail'])->name('sendmail');
Route::post('/new-safari', [HomeController::class, 'new_safari'])->name('new-safari');

Route::get('/destinations/{des}', [HomeController::class, 'destinations'])->name('destinations');

Route::get('/add-destinations', [HomeController::class, 'adddestinations'])->name('des.add');

Route::middleware('auth')->group(function () {
    Route::post('/insert-destination', [AdminController::class, 'insertdestination'])->name('des.insert');
    Route::get('/admin', [AdminController::class, 'admin'])->name('admin');
    Route::get('/destination-delete/{id}', [AdminController::class, 'destdelete'])->name('destination-delete');
    Route::get('/destination-edit/{id}', [AdminController::class, 'destedit'])->name('destination-edit');
    Route::post('/destination-update/{id}', [AdminController::class, 'destupdate'])->name('destination-update');
    Route::get('/new-hotel', [AdminController::class, 'new_hotel'])->name('hotel.view');
    Route::post('/insert-Hotel', [AdminController::class, 'inserthotel'])->name('hotel.insert');
    Route::get('/hotel-list', [AdminController::class, 'hotel_list'])->name('hotel.list');
    Route::get('/hotel-delete/{id}', [AdminController::class, 'hoteldelete'])->name('hotel-delete');
    Route::get('/hotel-edit/{id}', [AdminController::class, 'hoteledit'])->name('hotel-edit');
    Route::post('/hotel-update/{id}', [AdminController::class, 'hotelupdate'])->name('hotel-update');
});


Route::get('/sitemap.xml', [SitemapController::class, 'index']);

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

// Route::middleware('auth')->group(function () {
//     Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
//     Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
//     Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
// });

require __DIR__.'/auth.php';