@extends('partials.main')
@section('title')
    {{ 'Loyalty Program' }}
@endsection
@section('content')
    <!--************************************
                      Inner Banner Start
                    *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../thumbnails/{{ $banner->image }}">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>{{ $banner->heading }}</h1>
                        <h2>{{ $banner->subheading }}</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">{{ $banner->heading }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                      Inner Banner End
                    *************************************-->
    <!--************************************
                      Main Start
                    *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout">

        <div class="container-fluid">
            <div class="row">

                <div class="tg-posts tg-blogposts">
                    @foreach ($data as $item)
                        <article class="tg-post tg-verticaltop">
                            <iframe src="{{ $item->link }}" allowfullscreen></iframe>
                            {{-- <div class="tg-postcontent">

                                <div class="tg-posttitle">
                                    <h2><a href="blogdetail.html">{{ $item->title }}</a></h2>
                                </div>
                                <div class="tg-description">
                                    <p>{!! $item->detail !!}</p>
                                </div>

                            </div> --}}
                        </article>
                    @endforeach



                    {{-- <nav class="tg-pagination">
                        <ul>
                            <li class="tg-prevpage"><a href="javascript:void(0);"><i class="fa fa-angle-left"></i></a></li>
                            <li class="tg-active"><a href="javascript:void(0);">1</a></li>
                            <li><a href="javascript:void(0);">2</a></li>
                            <li><a href="javascript:void(0);">3</a></li>
                            <li><a href="javascript:void(0);">4</a></li>
                            <li class="tg-nextpage"><a href="javascript:void(0);"><i class="fa fa-angle-right"></i></a></li>
                        </ul>
                    </nav> --}}
                </div>
            </div>
        </div>
        <div class="container">
            <div class="para">
                {!! $portal->description !!}
            </div>
        </div>
        </div>
    </main>
    <!--************************************
                      Main End
                    *************************************-->
@endsection
