<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Explore Destinations</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: #fff;
            font-family: 'Poppins', sans-serif;
        }

        h2 {
            color: #fff;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
            margin: 20px 0;
            text-align: center;
        }

        .destination-card {
            border-radius: 12px;
            background: #fff;
            color: #333;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease-in-out;
            overflow: hidden;
        }

        .destination-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4);
        }

        .destination-card h5 {
            font-weight: bold;
        }

        .btn-primary {
            background: #ff9800;
            border: none;
            font-weight: bold;
            border-radius: 20px;
            transition: background 0.3s;
            text-align: left;
        }

        .btn-primary:hover {
            background: #e68900;
        }

        #map {
            height: 60vh;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        }

        .container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }

        .new-card {
            background: #ffcc00;
            color: #333;
            font-size: 20px;
            font-weight: bold;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            margin: 20px 0;
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Explore Your New Ride</h2>
        <div class="new-card">
            Ride Price: LKR{{ $job->ride }}
        </div>
        <div class="row">

            <div class="col-md-6">
                @foreach ($hotels as $index => $hotel)
                    <div class="destination-card p-3 mb-3">

                        <button class="btn btn-primary w-100 mb-3"><i class="fas fa-map-marker-alt"></i>
                            {{ $hotel->h_place }}</button>

                        <p><i class="fas fa-clock"></i> {{ $hotel->date }}</p>
                        <p><i class="fas fa-hotel"></i>
                            @if ($hotel->hotel != null)
                                Hotel: {{ $hotel->hotel }} <br>
                                Hotel Address: {{ $hotel->h_address }} <br>
                                Hotel Contact: {{ $hotel->h_contact }} <br>
                            @endif
                        </p>
                        <p><i class="far fa-sticky-note"></i> {{ $hotel->h_note }}</p>
                    </div>
                @endforeach
            </div>


            <div class="col-md-6">
                <h2>Map View</h2>
                <div id="map"></div>
            </div>

        </div>
    </div>
</body>
<?php
$itineraryArray = json_decode($data->itinerary, true);
$itineraryJSON = json_encode($itineraryArray);
?>
<script>
    var map;
    var directionsService;
    var directionsRenderer;
    var locationNames = <?php echo $itineraryJSON; ?>;

    console.log(locationNames);

    function initMap() {
        map = new google.maps.Map(document.getElementById("map"), {
            zoom: 5,
        });

        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map: map,
        });

        updateDirections();
    }

    function updateDirections() {
        var origin = locationNames[0];
        var destination = locationNames[locationNames.length - 1];
        var waypoints = locationNames.slice(1, -1);

        var waypointsArray = waypoints.map(function(waypoint) {
            return {
                location: waypoint,
                stopover: true,
            };
        });

        var request = {
            origin: origin,
            destination: destination,
            waypoints: waypointsArray,
            travelMode: google.maps.TravelMode.DRIVING,
        };

        directionsService.route(request, function(result, status) {
            if (status == google.maps.DirectionsStatus.OK) {
                directionsRenderer.setDirections(result);
            }
        });
    }
</script>
<script>
    function loadScript() {
        var script = document.createElement("script");
        script.src =
            "https://maps.googleapis.com/maps/api/js?key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4&libraries=places&callback=initMap";
        script.async = true;
        document.head.appendChild(script);
    }

    window.onload = loadScript;
</script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

</html>
