@extends('rider.layout.main')
@section('title')
    {{ 'user' }}
@endsection
@section('content')
    <style>
        form {
            background-color: #f9f9f9;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .text-center {
            text-align: center;
        }


        h3 {
            color: #333;
        }


        p {
            font-size: 14px;
            color: cyan;
        }


        h5 {
            color: #333;
            font-weight: bold;
        }


        button {
            background-color: #007BFF;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background-color: #0056b3;
        }

        h4.text-uppercase {
            color: white;
        }

        p {
            font-size: 14px;
            color: cyan;
        }

        .btn-iti {
            color: #fff;
            background-color: cyan;
            border-color: #2850a7;
        }

        .btn-iti:hover {
            color: cyan;
            background-color: rgb(255, 255, 255);
            border-color: #2850a7;
        }

        @media screen and (max-width: 768px) {
            .min-width-cell {
                min-width: 150px;
            }

        }
    </style>
    <div style="padding-top: 70px; padding-left: 10px; " class="height-100 bg-light ">
        <section id="stats-subtitle">
            <div class="row">
                <div class="col-12 mt-3 mb-1">
                    <h4 class="text-uppercase">Statistics</h4>
                    <p>Exploring Our Tour History</p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            <h4 class="mt-0 header-title"> Itinerary List</h4>
                            <div class="table-responsive">
                                <table id="mainTable" class="table">
                                    <thead>
                                        <tr>
                                            <th>Id</th>


                                            <th class="min-width-cell">Assigned date</th>
                                            <th class="min-width-cell">Job Invoice</th>

                                            <th>Action</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($jobs as $data)
                                            <tr>
                                                <td class="min-width-cell">{{ $loop->iteration }}</td>

                                                <td class="min-width-cell">{{ $data->created_at }}</td>

                                                <td class="min-width-cell">
                                                    {{ \App\Models\TourBooking::where('id', $data->tourbid)->first()->invoice ?? '' }}

                                                </td>
                                                {{-- <td>{{$data->id}}</td> --}}
                                                <td>
                                                    <a class="btn btn-iti edit"
                                                        href="{{ route('driver.job-view', $data->tourbid) }}"
                                                        role="button"> View</a>


                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>
                            </div>




                        </div>
                    </div>
                </div>
                <!-- end col -->

            </div>


        </section>
    </div>
@endsection
