@extends('partials.main')
@section('title')
    {{ 'TOUR PACKAGES' }}
@endsection
@section('content')
    <style>
        .tg-description span {
            color: #ff7550;
        }

        .tg-populartourtitle {
            width: 100%;
            float: left;
            height: 48px;
            padding: 0 0 20px;
        }

        .tg-description {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            max-height: 20.4em;
        }

        .mask {
            mask-image: url('images/frame-design.svg');

            mask-mode: alpha;
            -webkit-mask-image: url('images/frame-design.svg');
            -webkit-mask-mode: alpha;

            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
        }
        .itineraryDesc{
            height: 50px;
        }
    
    </style>
    <!--************************************
                                            Inner Banner Start
                                          *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../thumbnails/{{ $banner->image }}">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>{{ $banner->heading }}</h1>
                        <h2>{{ $banner->subheading }}</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">{{ $banner->heading }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                                            Inner Banner End
                                          *************************************-->
    <!--************************************
                                            Main Start
                                          *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">
                        <div class="tg-listing tg-listingvtwo">
                            <div class="tg-sectiontitle">
                                <h2> Tours</h2>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">

                                @foreach ($package as $package)
                                    <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 itineraryBox">
                                        <div class="tg-trendingtrip">
                                            <figure>
                                                <a href="/tour-detail/{{ $package->slug }}">
                                                    <div class="mask">
                                                        <img src="{{ asset('thumbnails/' . $package->thumbnail) }}"
                                                            class="Itinerary-gat" alt="image destinations">
                                                    </div>
                                                </a>
                                            </figure>
                                            <div class="tg-populartourcontent">
                                                <div class="tg-populartourtitle">
                                                    <h3><a href="/tour-detail/{{ $package->slug }}">
                                                            {{ $package->title }}
                                                        </a></h3>
                                                </div>
                                                <div class="tg-description itineraryDesc">
                                                    <p> {!! $package->description !!} </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tg-populartourfoot">
                                            <form action="/quotation" method="post">
                                                @csrf
                                                <input name="type" type="hidden" value="pack">
                                                <input name="name" type="hidden" value=" {{ $package->title }} ">
                                                <button class="tg-btnaddtocart" type="submit"> <i class="icon-icons240"></i>
                                                    <span>Request Quote </span></button>
                                            </form>
                                        </div>
                                    </div>
    
                                    @if ($loop->index  == 2)
                                        </div>
                                        <div class="row">
                                    @endif
                                @endforeach
                        </div>
                            <div class="clearfix"></div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--************************************
                                            Main End
                                          *************************************-->
@endsection
