@extends('partials.main')
@section('title')
    {{ 'Mirissa & Trincomalee Whale Watching' }}
@endsection
@section('content')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js"></script>
    <style>
        .activity-slide img {
            height: 500px;
            object-fit: cover;
        }

        .carousel-wrapper {
            width: 1000px;
            margin: auto;
            position: relative;
            text-align: center;
            font-family: sans-serif;
        }

        .owl-carousel .owl-nav {
            overflow: hidden;
            height: 0px;
        }

        .owl-theme .owl-dots .owl-dot.active span,
        .owl-theme .owl-dots .owl-dot:hover span {
            background: #464449;
        }

        .owl-carousel .item {
            text-align: center;
        }

        .owl-carousel .nav-button {
            height: 50px;
            width: 25px;
            cursor: pointer;
            position: absolute;
            top: 110px !important;
        }

        .owl-carousel .owl-prev.disabled,
        .owl-carousel .owl-next.disabled {
            pointer-events: none;
            opacity: 0.25;
        }

        .owl-carousel .owl-prev {
            left: -35px;
        }

        .owl-carousel .owl-next {
            right: -35px;
        }

        .owl-theme .owl-nav [class*=owl-] {
            color: #ffffff;
            font-size: 39px;
            background: #000000;
            border-radius: 3px;
        }

        .owl-carousel .prev-carousel:hover {
            background-position: 0px -53px;
        }

        .owl-carousel .next-carousel:hover {
            background-position: -24px -53px;
        }

        .owl-theme .owl-nav [class*='owl-'] {

            padding: 10px 7px;

        }

        .tg-newcontent {
            overflow: hidden;
            padding: 18px 0 0 17px;

        }

        .tg-newcontent a {
            font-weight: 500;

        }
    </style>

    <!--************************************
                         Inner Banner Start
                        *************************************-->
    <div class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/IMG_8856.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>{{ $data->title }}</h1>
                        <h2>Get Ready for an Epic Marine Adventure: Pre-Book Your Mirissa and Trincomalee Whale Watching
                            Tour to Witness Majestic Giants of the Ocean</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">Mirissa & Trincomalee Whale Watching</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--************************************
                         Inner Banner End
                        *************************************-->
    <!--************************************
                         Main Start
                        *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout tg-bglight">
        <div class="container">
            <div class="row">
                <div id="tg-twocolumns" class="tg-twocolumns">
                    <div class="col-xs-12 col-sm-8 col-md-8 col-lg-9 pull-left">
                        <div class="safari-content">
                            <div class="tg-populartourtitle">
                                <h3><a href="">{{ $data->title }}</a></h3>
                            </div>
                            <div>
                                {!! $data->shdescription !!}

                                </p>
                                <div class="activeity">
                                    <h1 style="line-height:1.4; font-size:25px; font-weight: bold;">Request Free Quote For
                                        Whale and Dolphin Watching</h1>
                                    <form action="/new-safari" method="post">
                                        @csrf
                                        <input type="hidden" name="type" class="form-control"
                                            value=" Whale and Dolphin  Watching">

                                        <div class="form-group">
                                            <strong>Salutation :</strong>
                                            <select name="salutation">
                                                <option value="Mr.">Mr.</option>
                                                <option value="Mrs.">Mrs.</option>
                                                <option value="Miss.">Miss.</option>
                                            </select>

                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="name" class="form-control"
                                                placeholder="Full Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email*"
                                                required="">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="phone" class="form-control"
                                                placeholder="Contact Number With Country Code">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="adults" class="form-control"
                                                placeholder="Number Of Adults">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="children" class="form-control"
                                                placeholder="Numbre Of Children">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="country" class="form-control" placeholder="Country">
                                        </div>


                                        <div class="form-group">
                                            <label for="start-date"> Date</label>
                                            <input type="date" name="date" class="form-control" placeholder=" Date">
                                        </div>

                                        <div class="form-group">
                                            <label for="start-date">Location</label>
                                            <select class="form-control" name="location" id="">
                                                <option value="trincomalee"> Trincomalee</option>
                                                <option value="mirissa"> Mirissa</option>
                                            </select>
                                        </div>



                                        <div class="form-group">
                                            <label for="pickup_location">Pick Up Location/Hotel Address &amp; Any Other
                                                Questions You Have</label>
                                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3"></textarea>
                                        </div>

                                        <div class="row">

                                            <div class=" row col-xs-8 col-sm-12 col-md-6 col-lg-6">

                                            </div>


                                            <div class=" row col-xs-12 col-sm-12 col-md-6 col-lg-6">
                                                <button class="tg-btn" type="submit" name="submit">Submit</button>
                                            </div>
                                        </div>


                                    </form>

                                </div>

                                <hr>
                                <div>
                                    {!! $data->description !!}

                                </div>

                            </div>

                        </div>
                        <div class="slider">
                            <div id="owl-demo" class="owl-carousel owl-theme">

                                @foreach ($images as $image)
                                    <div class="item activity-slide"> <img src="{{ asset('thumbnails/' . $image->files) }}"
                                            alt="" srcset="">
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-4 col-md-4 col-lg-3 pull-right">
                        <aside id="tg-sidebar" class="tg-sidebar">
                            <div class="tg-widget tg-widgetlatesttour">
                                <div class="tg-widgettitle">
                                    <h3>Other activity</h3>
                                </div>
                                <div class="tg-widgetcontent">
                                    <ul>
                                        @foreach ($others as $item)
                                            <li>
                                                <figure>
                                                    <a href="/safari/{{ $item->slug }}"><img
                                                            src={{ asset('thumbnails/' . $item->thumbnail) }}
                                                            alt="image destinations"></a>
                                                </figure>
                                                <div class="tg-newcontent">
                                                    <h4><a href="/safari/{{ $item->slug }}">{{ $item->title }}</a>
                                                    </h4>

                                                </div>
                                            </li>
                                        @endforeach


                                    </ul>
                                </div>
                            </div>

                            <div class="tg-widget tg-widgetcatagories">
                                <div class="tg-widgettitle">
                                    <h3>Tour facility</h3>
                                </div>
                                <div class="tg-widgetcontent">
                                    <ul>
                                        <li><a href="/ticket-price">Tourist Entrance ticket prices in sri lanka</a></li>
                                        <li><a href="/railway-ticket">Railway/Train ticket reservation in sri lanka</a>
                                        </li>
                                        {{-- <li><a href="#">Hiking in The Wild</a></li>
                                        <li><a href="#">Luxury Tours in Alps</a></li>
                                        <li><a href="#">Holiday & Seasonal Tours</a></li> --}}
                                    </ul>
                                </div>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--************************************
                         Main End
                        *************************************-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css"></script>
    <script src=""></script>

    <script>
        $(document).ready(function() {

            $("#owl-demo").owlCarousel({
                navigation: true,
                items: 1,
                loop: true,
                nav: true,
                navText: ["<div class='nav-button owl-prev'>‹</div>",
                    "<div class='nav-button owl-next'>›</div>"
                ],


                autoplay: true,
                animateOut: 'fadeOut',
                animateIn: 'fadeIn',
            });

        });
    </script>
@endsection
