@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Add Employee</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Employee</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Employee</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Add Employee</h4>

                                <form action="{{ route('users.update', $user->id) }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')

                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" name="name"
                                                value="{{ old('name', $user->name) }}" required>
                                        </div>
                                    </div>

                                    <input class="form-control" type="hidden" value="employee" name="role" required>

                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" name="email"
                                                value="{{ old('email', $user->email) }}" required>
                                        </div>
                                    </div>

                                  
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">New Password</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="password" name="password"
                                                placeholder="Leave blank to keep current">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Confirm Password</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="password" name="password_confirmation"
                                                placeholder="Leave blank to keep current">
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Update
                                            </button>
                                            <a href="{{ route('users.index') }}"
                                                class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </a>
                                        </div>
                                    </div>
                                </form>


                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                var i = 0; // Declare and initialize i
                $("#addRow").click(function(event) {
                    event.preventDefault();
                    i++; // Increment i
                    var newRow = '<tr>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][day]"></td>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][title]"></td>' +
                        '<td>  <textarea  name="inputfilde[' + i +
                        '][description]" class="form-control" id="" cols="50" rows="1"></textarea></td>' +
                        '<td><button class="deleteRow btn btn-danger">Delete</button></td>' +
                        '</tr>';
                    $("#qaTable tbody").append(newRow);
                    console.log(i);
                });

                $(document).on("click", ".deleteRow", function() {
                    $(this).closest("tr").remove();
                });

            });
        </script>
    @endsection
