@extends('client.layout.main')
@section('title')
    {{ 'user' }}
@endsection
@section('content')
    <style>
        form {
            background-color: #f9f9f9;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }


        .text-center {
            text-align: center;
        }


        h3 {
            color: #333;
        }


        p {
            font-size: 14px;
            color: #555;
        }


        h5 {
            color: #333;
            font-weight: bold;
        }


        button {
            background-color: #007BFF;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background-color: #0056b3;
        }
    </style>
    <div style="padding-top: 70px; padding-left: 10px; " class="height-100 bg-light ">
        <section id="stats-subtitle">
            <div class="row">
                <div class="col-12 mt-3 mb-1">
                    <h4 class="text-uppercase">My Tours</h4>
                    <p>Exploring Our Tour History</p>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">





                            <div class="dynamic-table">
                                <table class="table table-bordered responsive" id="dynamic-table">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Booking</th>
                                            <th>Special Note</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($hotels as $index => $hotel)
                                            <tr>
                                                <td>
                                                    {{ $hotel->date }} <br>
                                                </td>
                                                <td>



                                                    @if ($hotel->hotel == null)
                                                    @else
                                                        Hotel: {{ $hotel->hotel }}
                                                        Hotel Address: {{ $hotel->h_address }}
                                                        Hotel Contact: {{ $hotel->h_contact }}
                                                    @endif
                                                    Destination:{{ $hotel->h_place }}<br>
                                                </td>
                                                <td>

                                                    {{ $hotel->h_note }}
                                                </td>

                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <!--<div class="form-group row">-->
                            <!--    <label for="package" class="col-sm-2 col-form-label">Package</label>-->
                            <!--    <div class="col-sm-10">-->
                            <!--        <input class="form-control" type="text" id="package" name="package"-->
                            <!--            value="{{ $data->package }}" readonly placeholder=" ">-->
                            <!--    </div>-->
                            <!--</div>-->

                            <div class="form-group row">
                                <label for="price" class="col-sm-2 col-form-label">Price</label>
                                <div class="col-sm-10">
                                    <input class="form-control" type="text" id="price" name="price"
                                        value="{{ $data->price }}" readonly placeholder=" ">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="pre_paid" class="col-sm-2 col-form-label">Pre Paid</label>
                                <div class="col-sm-10">
                                    <input class="form-control" type="text" id="pre_paid" name="pre_paid"
                                        value="{{ $data->prepaid }}" readonly placeholder=" ">
                                </div>
                            </div>
                            <div class="form-group row">
                                @if ($data->total_due == 0)
                                    <div class="col-sm-12 text-success">
                                        Payment Complete
                                    </div>
                                @else
                                    <div class="col-sm-12 text-danger">
                                        Payment Not Complete
                                    </div>
                                @endif


                            </div>



                        </div>
                    </div>
                </div>
            </div>
            <div id="map" style="height: 500px; width: 100%;margin-bottom:60px;"></div>


        </section>
    </div>
    <?php
    $itineraryArray = json_decode($data->itinerary, true);
    $itineraryJSON = json_encode($itineraryArray);
    ?>
    <script>
        var map;
        var directionsService;
        var directionsRenderer;
        var locationNames = <?php echo $itineraryJSON; ?>;

        console.log(locationNames);

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 5,
            });

            directionsService = new google.maps.DirectionsService();
            directionsRenderer = new google.maps.DirectionsRenderer({
                map: map,
            });

            updateDirections();
        }

        function updateDirections() {
            var origin = locationNames[0];
            var destination = locationNames[locationNames.length - 1];
            var waypoints = locationNames.slice(1, -1);

            var waypointsArray = waypoints.map(function(waypoint) {
                return {
                    location: waypoint,
                    stopover: true,
                };
            });

            var request = {
                origin: origin,
                destination: destination,
                waypoints: waypointsArray,
                travelMode: google.maps.TravelMode.DRIVING,
            };

            directionsService.route(request, function(result, status) {
                if (status == google.maps.DirectionsStatus.OK) {
                    directionsRenderer.setDirections(result);
                }
            });
        }
    </script>
    <script>
        function loadScript() {
            var script = document.createElement("script");
            script.src =
                "https://maps.googleapis.com/maps/api/js?key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4&libraries=places&callback=initMap";
            script.async = true;
            document.head.appendChild(script);
        }

        window.onload = loadScript;
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@endsection
