@extends('backend.layouts.main')
@section('content')
    <link href="{{ asset('assets/plugins/fancy-file-uploader/fancy_fileupload.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/plugins/Drag-And-Drop/dist/imageuploadify.min.css') }}" rel="stylesheet" />
    <style>
        .btnwrap {
            text-align: center;
        }

        i.fa.fa-plus {
            padding-top: 8px;
            padding-right: 26px;
        }

        .imagePreview {
            width: 100%;
            height: 180px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            position: absolute;
            top: 0px;
            right: 15px;
            width: 30px;
            height: 30px;
            text-align: center;
            line-height: 30px;
            background-color: rgba(255, 255, 255, 0.6);
            cursor: pointer;
        }

        .imgAdd {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .cover input:not([type="radio"]) {
            padding: 0px !important;
            border: none !important;
            width: 100%;
            background-color: transparent;
            border-radius: 8px;
            -webkit-border-radius: 8px;
            -moz-border-radius: 8px;
            -ms-border-radius: 8px;
            -o-border-radius: 8px;
            color: #c4cbf9;
        }

        .imagePreview1 {
            width: 100%;
            height: 180px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .cover {
            margin-bottom: 15px;
        }
    </style>
    <div class="page-wrapper">
        <div class="page-content">


            <div class="row">
                <div class="col-xl-9 mx-auto">




                    <h6 class="mb-0 text-uppercase">Add Product</h6>
                    <hr />
                    <div class="card">
                        <div class="card-body table-responsive">
                            <form action="/addproduct" method="post" enctype="multipart/form-data">
                                @csrf
                                @foreach ($errors->all() as $error)
                                    <div class="flash-message">
                                        <p class="alert alert-danger"> {{ $error }}</p>
                                    </div>
                                @endforeach


                                @foreach (['success', 'danger'] as $msg)
                                    @if (Session::has('alert-' . $msg))
                                        <script>
                                            function info_noti() {
                                                Lobibox.notify('default', {
                                                    pauseDelayOnHover: true,
                                                    continueDelayOnInactiveTab: false,
                                                    size: 'mini',
                                                    position: 'top right',
                                                    icon: 'bx bx-info-circle',
                                                    msg: "{{ Session::get('alert-' . $msg) }}"
                                                });
                                            }
                                        </script>
                                    @endif
                                @endforeach
                                <div class="form-group row">
                                    <label for="example-text-input" class="col-sm-4 col-form-label">Cover Image</label>
                                    <div class="col-sm-4 cover">
                                        <div class="imagePreview1">
                                        </div>
                                        <p class="btnwrap">
                                            <label class="btn btn-warning">
                                                Upload Cover Image<input type="file" class="uploadFile img"
                                                    value="Upload Photo" name="cover"
                                                    style="width: 100%;height: 0px;overflow: hidden;">
                                            </label>
                                        </p>

                                    </div><!-- col-2 -->
                                    {{-- <i class="fa fa-plus imgAdd"></i> --}}
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Title:</label>
                                    <input name="title" type="text" class="form-control"
                                        placeholder="maximum 250 characters">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Category:</label>
                                    <select name="cat" class="form-select form-select-sm mb-3"
                                        aria-label=".form-select-sm example">
                                        <option value="">Please Select</option>
                                        @foreach ($cat as $cats)
                                            <option value="{{ $cats->slug }}">{{ $cats->category }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Price:</label>
                                    <input type="number" name="price" step="0.01" class="form-control">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Description:</label>
                                    <textarea id="mytextarea" name="description"></textarea>

                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Weight (grams) :</label>
                                    <input name="weight" type="number" class="form-control">


                                </div>
                                <div class="mb-3">
                                    <label class="form-label">SKU:</label>
                                    <input name="sku" type="text" class="form-control">


                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Meta Keywords:</label>
                                    <input name="metakeywords" type="text" class="form-control">


                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Meta Description:</label>
                                    <input name="metadata" type="text" class="form-control">


                                </div>

                                <br>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-sm-4 imgUp">
                                            <div class="imagePreview"></div>
                                            <label class="btn btn-primary">
                                                Upload<input type="file" class="uploadFile img" value="Upload Photo"
                                                    name="image[0]" style="width: 0px;height: 0px;overflow: hidden;">
                                            </label>
                                        </div><!-- col-2 -->
                                        <i class="fa fa-plus imgAdd"></i>
                                    </div><!-- row -->
                                </div><!-- container -->



                                <div class="col" style="margin-left: 16px;margin-top: 19px;">
                                    <button type="submit" class="btn btn-primary px-5 rounded-0">Submit</button>
                                </div>
                                </br>
                                </br>


                                <div class="row">



                            </form>
                        </div>
                    </div>

                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
                    <script
                        src="{{ asset('https://cdn.tiny.cloud/1/bnpysjtk3uk78olinn929jomg4qdx3exrhy3v59xabnj34ug/tinymce/5/tinymce.min.js') }}"
                        referrerpolicy="origin"></script>
                    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


                    <script src="{{ asset('assets/plugins/fancy-file-uploader/jquery.ui.widget.js') }}"></script>
                    <script src="{{ asset('assets/plugins/fancy-file-uploader/jquery.fileupload.js') }}"></script>
                    <script src="{{ asset('assets/plugins/fancy-file-uploader/jquery.iframe-transport.js') }}"></script>
                    <script src="{{ asset('assets/plugins/fancy-file-uploader/jquery.fancy-fileupload.js') }}"></script>
                    <script src="{{ asset('assets/plugins/Drag-And-Drop/dist/imageuploadify.min.js') }}"></script>
                    <script type="text/javascript">
                        $(function() {
                            $(document).on("change", ".uploadFile", function() {
                                var uploadFile = $(this);
                                var files = !!this.files ? this.files : [];
                                if (!files.length || !window.FileReader)
                                    return; // no file selected, or no FileReader support

                                if (/^image/.test(files[0].type)) { // only image file
                                    var reader = new FileReader(); // instance of the FileReader
                                    reader.readAsDataURL(files[0]); // read the local file

                                    reader.onloadend = function() { // set image data as background of div
                                        //alert(uploadFile.closest(".upimage").find('.imagePreview1').length);
                                        uploadFile.closest(".cover").find('.imagePreview1').css("background-image",
                                            "url(" + this.result + ")");
                                    }
                                }

                            });
                        });
                    </script>
                    <script type="text/javascript">
                        var i = 1;
                        $(".imgAdd").click(function() {
                            $(this).closest(".row").find('.imgAdd').before(
                                '<div class="col-sm-4 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" class="uploadFile img" value="Upload Photo" name="image[' +
                                i +
                                ']" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-times del"></i></div>'
                            );
                            ++i;
                        });


                        $(document).on("click", "i.del", function() {
                            $(this).parent().remove();

                        });



                        $(function() {
                            $(document).on("change", ".uploadFile", function() {
                                var uploadFile = $(this);
                                var files = !!this.files ? this.files : [];
                                if (!files.length || !window.FileReader)
                                    return; // no file selected, or no FileReader support

                                if (/^image/.test(files[0].type)) { // only image file
                                    var reader = new FileReader(); // instance of the FileReader
                                    reader.readAsDataURL(files[0]); // read the local file

                                    reader.onloadend = function() { // set image data as background of div
                                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                                            "url(" + this.result + ")");
                                    }
                                }

                            });
                        });
                    </script>
                    <script>
                        tinymce.init({
                            selector: '#mytextarea'
                        });
                    </script>
                @endsection
