@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <style>
        div#datatable-buttons_filter {
            text-align: end;
        }
    </style>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="container">
                        <h4>Attendance for {{ $user->name }} – {{ \Carbon\Carbon::parse($month)->format('F Y') }}</h4>

                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Check In</th>
                                    <th>Check Out</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $systemStartDate = \Carbon\Carbon::parse('2025-07-03');
                                @endphp
                                @foreach ($period as $date)
                                    @php
                                        $day = $date->toDateString();
                                        $record = $attendances[$day] ?? null;
                                        $isWeekend = $date->isWeekend();
                                        $isHoliday = in_array($day, $holidays);
                                    @endphp
                                    <tr>
                                        <td>{{ $day }}</td>
                                        <td>
                                            @if ($record)
                                                {{ ucfirst($record->status) }}
                                            @elseif ($isHoliday)
                                                <span class="text-primary">Holiday</span>
                                            @elseif ($isWeekend)
                                                <span class="text-warning">Weekend</span>
                                            @elseif ($date->lessThan($systemStartDate) || $date->greaterThanOrEqualTo(now()->startOfDay()))
                                                -
                                            @else
                                                <span class="text-danger">Absent</span>
                                            @endif
                                        </td>
                                        <td>{{ $record->check_in ?? '-' }}</td>
                                        <td>{{ $record->check_out ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>



                        </table>

                        <a href="{{ route('admin.attendance.monthly', ['month' => $month]) }}"
                            class="btn btn-secondary">Back to Summary</a>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
