@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Add Employee</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Employee</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Employee</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row justify-content-center mt-5">
                    <div class="col-md-6">
                        <div class="card shadow-lg border-0 rounded-lg">
                            <div class="card-body text-center">

                                <h2 class="mb-4 text-primary">🕒 Today's Attendance</h2>

                                @if (session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                    </div>
                                @endif

                                @if (session('error'))
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        {{ session('error') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                    </div>
                                @endif

                                @if ($attendance)
                                    <div class="alert alert-info mt-3">
                                        ✅ <strong>Check-in:</strong> {{ $attendance->check_in ?? 'N/A' }} <br>

                                        @if ($attendance->check_out)
                                            ✅ <strong>Check-out:</strong> {{ $attendance->check_out }}
                                        @else
                                            <!-- Show checkout button -->
                                            <form method="POST" action="{{ route('attendance.checkout') }}" class="mt-3">
                                                @csrf
                                                <button type="submit" class="btn btn-warning">🔚 Check Out</button>
                                            </form>
                                        @endif
                                    </div>
                                @else
                                    <form method="POST" action="{{ route('attendance.checkin') }}">
                                        @csrf
                                        <button type="submit" class="btn btn-lg btn-success px-5 mt-3">
                                            📍 Mark Attendance
                                        </button>
                                    </form>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                var i = 0; // Declare and initialize i
                $("#addRow").click(function(event) {
                    event.preventDefault();
                    i++; // Increment i
                    var newRow = '<tr>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][day]"></td>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][title]"></td>' +
                        '<td>  <textarea  name="inputfilde[' + i +
                        '][description]" class="form-control" id="" cols="50" rows="1"></textarea></td>' +
                        '<td><button class="deleteRow btn btn-danger">Delete</button></td>' +
                        '</tr>';
                    $("#qaTable tbody").append(newRow);
                    console.log(i);
                });

                $(document).on("click", ".deleteRow", function() {
                    $(this).closest("tr").remove();
                });

            });
        </script>
    @endsection
