@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <style>
        div#datatable-buttons_filter {
            text-align: end;
        }
    </style>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="container">
                                <h4>Monthly Attendance Report</h4>

                                <form method="GET" action="{{ route('admin.attendance.monthly') }}" class="mb-4">
                                    <label for="month">Select Month:</label>
                                    <input type="month" id="month" name="month" value="{{ $month }}"
                                        class="form-control" style="max-width: 300px;">
                                    <button type="submit" class="btn btn-primary mt-2">Filter</button>
                                </form>

                                <table class="table table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>User</th>
                                            <th>Full Days</th>
                                            <th>Half Days</th>
                                            <th>Short Leaves</th>
                                            <th>Annual Leaves</th>
                                            <th>Nopay</th>
                                            <th>Total present days</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($summary as $item)
                                            <tr>
                                                <td>
                                                    <a
                                                        href="{{ route('admin.attendance.user', ['user' => $item['user']->id, 'month' => $month]) }}">
                                                        {{ $item['user']->name }}
                                                    </a>
                                                </td>

                                                <td>{{ $item['full'] }}</td>
                                                <td>{{ $item['half'] }}</td>
                                                <td>{{ $item['short'] }}</td>
                                                <td>{{ $item['absent'] }}</td>
                                                <td>{{ $item['nopay'] }}</td>
                                                <td>{{ $item['present_days'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
