@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <style>
        #googleMap {
            height: 400px;
        }
    </style>
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div id="output"></div>
                                <div id="distances"></div>
                                <div id="googleMap"></div>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
        <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4">
        </script>
        <script>
            var destination = ["Horana, Sri Lanka", "Galle, Sri Lanka", "Negombo, Sri Lanka"];
            var origin = destination[0];
            var myLatLng = {
                lat: 6.68209484853092,
                lng: 80.32611376175865
            };
            var places = "";

            var mapOptions = {
                center: myLatLng,
                zoom: 10,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
            };

            var map = new google.maps.Map(document.getElementById("googleMap"), mapOptions);

            var directionsService = new google.maps.DirectionsService();
            var directionsDisplay = new google.maps.DirectionsRenderer();
            directionsDisplay.setMap(map);

            function calculateDistance() {
                places = origin;

                var waypoints = destination.slice(1).map(function(place) {
                    return {
                        location: place,
                        stopover: true,
                    };
                });

                var request = {
                    origin: origin,
                    destination: destination[destination.length - 1],
                    waypoints: waypoints,
                    travelMode: google.maps.TravelMode.DRIVING,
                    unitSystem: google.maps.UnitSystem.METRIC,
                };

                directionsService.route(request, function(result, status) {
                    if (status == google.maps.DirectionsStatus.OK) {
                        var totalDistance = 0;
                        var totalDuration = 0;
                        var distancesText = "";

                        for (var i = 0; i < result.routes[0].legs.length; i++) {
                            var leg = result.routes[0].legs[i];
                            totalDistance += leg.distance.value;
                            totalDuration += leg.duration.value;

                            if (i < waypoints.length) {
                                distancesText +=
                                    "<div id='dist'>" +
                                    "Destination " +
                                    String.fromCharCode(65 + i) +
                                    " to Destination " +
                                    String.fromCharCode(66 + i) +
                                    ": " +
                                    leg.distance.text +
                                    "<br>" +
                                    " </div>";
                            }
                        }

                        var totalDistanceInKm = (totalDistance / 1000).toFixed(2);
                        var totalDurationText = formatDuration(totalDuration);

                        const output = document.querySelector("#output");
                        output.innerHTML =
                            "<p class='alert-success'>From: " +
                            origin +
                            "<br>" +
                            "Total Distance <i class='fas fa-road'></i>: " +
                            totalDistanceInKm +
                            " km" +
                            "<br>" +
                            "Total Duration <i class='fas fa-clock'></i>: " +
                            totalDurationText +
                            ".</p>";

                        document.getElementById("distances").innerHTML = distancesText;
                        directionsDisplay.setDirections(result);
                    } else {
                        directionsDisplay.setDirections({
                            routes: []
                        });
                        map.setCenter(myLatLng);
                        const output = document.querySelector("#output");
                        output.innerHTML =
                            "<div class='alert-danger'><i class='fas fa-exclamation-triangle'></i> Could not retrieve driving distance.</div>";
                    }
                });
            }

            function formatDuration(durationInSeconds) {
                var hours = Math.floor(durationInSeconds / 3600);
                var minutes = Math.floor((durationInSeconds % 3600) / 60);

                if (hours === 0) {
                    return minutes + " min";
                } else {
                    return hours + " hr " + minutes + " min";
                }
            }

            // Automatically run the calculation when the page loads
            calculateDistance();
        </script>
    @endsection
