@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <style>
        .newhotel {
            display: none;
        }

        <style>.select2-container--default .select2-results__option--selected {
            background-color: #ccc;
            color: #000;
        }

        .select2-container--default li {
            color: black;
        }
    </style>
    </style>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page-title -->

                {{-- 
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif --}}


                {{-- @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <ul class="list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li> {{ $error }} </li>
                            @endforeach
                        </ul>
                    </div>
                @endif --}}
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/quotation-update/{{ $quotation->id }}" method="POST" id="myForm"
                                    enctype="multipart/form-data">
                                    @csrf

                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name </label>
                                        <div class="col-sm-10">
                                            @php
                                                $user = \App\Models\Client::where('id', $quotation->clientid)->first();
                                            @endphp
                                            <input class="form-control" readonly type="text"
                                                value="{{ $user ? $user->name : 'No User Found' }}" name="name" required>

                                            <input class="form-control" readonly type="hidden"
                                                value="{{ $quotation->clientid }}" name="clientid" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="email" value="{{ $quotation->email }}"
                                                name="email" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label"> Package Type</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{ $quotation->tour_type }}"
                                                name="packagetype" readonly required>



                                            </select>

                                        </div>
                                    </div>
                                    @if ($quotation->tour_type == 't-package')
                                        <div class="">
                                            <div class="dynamic-table table-responsive">
                                                <table class="table table-bordered responsive" id="dynamic-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Location</th>
                                                            <th>Activities</th>
                                                            <th>Special Note</th>
                                                            <th>Hotel</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($quotation->rows as $index => $detail)
                                                            <tr
                                                                data-activities="{{ json_encode($detail->activities->pluck('activity')->toArray()) }}">

                                                                <td>
                                                                    Date <input class="form-control" type="date"
                                                                        value="{{ $detail->date }}" required
                                                                        name="date[{{ $index }}]">
                                                                    <input type="hidden" name="day[{{ $index }}]"
                                                                        value="{{ $index + 1 }}">
                                                                </td>
                                                                <td>
                                                                    Destination
                                                                    <select class="form-control select2 destination"
                                                                        name="destination[{{ $index }}]">
                                                                        <option value="">Select Destination</option>
                                                                        @foreach ($destinations as $des)
                                                                            <option value="{{ $des->id }}"
                                                                                {{ $des->id == $detail->destination ? 'selected' : '' }}>
                                                                                {{ $des->title }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <div class="activity-list">
                                                                        @foreach ($detail->activities as $activity)
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                    type="checkbox"
                                                                                    name="activities[{{ $index }}][]"
                                                                                    value="{{ $activity->activity }}"
                                                                                    checked>
                                                                                <label
                                                                                    class="form-check-label">{{ $activity->activity }}</label>
                                                                            </div>
                                                                        @endforeach
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <textarea class="form-control" name="note[{{ $index }}]">{{ $detail->note }}</textarea>
                                                                </td>
                                                                <td>
                                                                    <input class="form-control" type="text"
                                                                        name="hotel[{{ $index }}]"
                                                                        value="{{ $detail->hotel }}">
                                                                    <br>
                                                                    <select class="form-control mt-2"
                                                                        name="basis[{{ $index }}]">
                                                                        <option value="">Select Basis</option>
                                                                        <option value="Bed & Breakfast Basis"
                                                                            {{ $detail->basis == 'Bed & Breakfast Basis' ? 'selected' : '' }}>
                                                                            Bed & Breakfast Basis
                                                                        </option>
                                                                        <option
                                                                            value="Half Board Basis (Breakfast & Dinner)"
                                                                            {{ $detail->basis == 'Half Board Basis (Breakfast & Dinner)' ? 'selected' : '' }}>
                                                                            Half Board Basis (Breakfast & Dinner)
                                                                        </option>
                                                                        <option value="Full Board Basis (All 3 Meals)"
                                                                            {{ $detail->basis == 'Full Board Basis (All 3 Meals)' ? 'selected' : '' }}>
                                                                            Full Board Basis (All 3 Meals)
                                                                        </option>
                                                                        <option value="Breakfast + Complimentary Dinner"
                                                                            {{ $detail->basis == 'Breakfast + Complimentary Dinner' ? 'selected' : '' }}>
                                                                            Breakfast + Complimentary Dinner
                                                                        </option>
                                                                    </select>

                                                                </td>
                                                                <td>
                                                                    <button type="button"
                                                                        class="btn btn-danger remove-row">Remove</button>
                                                                    <button type="button"
                                                                        class="btn btn-success add-row">Add
                                                                        Row</button>
                                                                </td>
                                                            </tr>
                                                            @php
                                                                $rowindex = $index + 1;
                                                            @endphp
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group car-driver ">
                                            <label for="example-text-input" class="col-sm-4 col-form-label">Duration
                                            </label>
                                            <div class="col-sm-5">
                                                <label for="example-text-input" class="col-sm-4 col-form-label">Start Date
                                                </label>
                                                <input class="form-control" type="date"
                                                    value="{{ $quotation->tour_from }}" name="from">
                                            </div>
                                            <div class="col-sm-5">
                                                <label for="example-text-input" class="col-sm-4 col-form-label">
                                                    End Date </label>
                                                <input class="form-control" type="date"
                                                    value="{{ $quotation->tour_to }}" name="to">
                                            </div>


                                        </div>
                                    @endif



                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Subject</label>
                                        <div class="col-sm-10">

                                            <select class="form-control" name="detail" id="detail">
                                                <option @if ($quotation->description == 'Your Customized Tour Quotation - Car') selected @endif
                                                    value="Your Customized Tour Quotation - Car">Your Customized
                                                    Tour Quotation - Car</option>
                                                <option @if ($quotation->description == 'Your Customized Tour Quotation - Van') selected @endif
                                                    value="Your Customized Tour Quotation - Van">Your Customized Tour
                                                    Quotation - Van</option>
                                                <option @if ($quotation->description == 'Your Customized Tour Quotation - Van (7 Pax & Above)') selected @endif
                                                    value="Your Customized Tour Quotation - Van (7 Pax & Above)">Your
                                                    Customized Tour Quotation - Van (7 Pax & Above)</option>
                                                <option @if ($quotation->description == 'Your Customized Tour Quotation - Bus') selected @endif
                                                    value="Your Customized Tour Quotation - Bus">Your Customized Tour
                                                    Quotation - Bus</option>
                                                <option @if ($quotation->description == 'Your Tailored Day Excursion Quote Inside - Car') selected @endif
                                                    value="Your Tailored Day Excursion Quote Inside - Car">Your Tailored
                                                    Day Excursion Quote Inside - Car</option>
                                                <option @if ($quotation->description == 'Your Tailored Day Excursion Quote Inside - Van') selected @endif
                                                    value="Your Tailored Day Excursion Quote Inside - Van">Your Tailored
                                                    Day Excursion Quote Inside - Van</option>
                                                <option @if ($quotation->description == 'Your Airport Transfer Quote') selected @endif
                                                    value="Your Airport Transfer Quote">Your Airport Transfer Quote
                                                </option>
                                            </select>

                                            {{-- <textarea rows="5" class="form-control" name="deatil" id="">
                                                        {!! $quotation->description !!}
                                                        </textarea> --}}

                                            <!-- <input class="form-control" value="{{ $quotation->description }}" required type="text" placeholder=" "
                                                                                                                                                                        name="deatil"> -->
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Pre Payment Amount</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" value="{{ $quotation->pre_payment }}" required
                                                type="text" placeholder=" " name="pre_payment">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Payament Link</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" required type="text" placeholder=" "
                                                value="{{ $quotation->payment_link }}" name="payment_link">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label"> Vehicle {{ $quotation->vehicle }}</label>
                                        <div class="col-sm-10">

                                            <select class="form-control" name="vehicle" id="">
                                                <option value="Car" @if ($quotation->vehicle == 'Car') selected @endif>
                                                    Car</option>
                                                <option value="Van" @if ($quotation->vehicle == 'Van') selected @endif>
                                                    Van</option>
                                                <option value="Van (7 Pax & Above)"
                                                    @if ($quotation->vehicle == 'Van (7 Pax & Above)') selected @endif>Van (7 Pax & Above)
                                                </option>
                                                <option value="Bus" @if ($quotation->vehicle == 'Bus') selected @endif>
                                                    Bus</option>
                                            </select>

                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Luxury Cost</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" value="{{ $quotation->luxury_cost }}" required
                                                type="text" placeholder=" " name="luxury_cost">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Economy Cost</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" value="{{ $quotation->economy_cost }}" required
                                                type="text" placeholder=" " name="economy_cost">
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" id="submitBtn"
                                                class="btn btn-primary waves-effect waves-light">Update</button>
                                            <a href="{{ url()->previous() }}" type="reset"
                                                class="btn btn-secondary waves-effect m-l-5">Back</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
            </div>
            <!-- container-fluid -->
        </div>
        <!-- content -->
    </div>
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
    <script>
        $(document).ready(function() {
            let rowIndex = {{ $rowindex }};

            // Initialize Select2
            $(".select2").select2();

            // Function to fetch activities based on the selected destination
            function fetchActivities(destinationId, activityDiv, rowIdx, checkedActivities = []) {
                if (destinationId) {
                    $.ajax({
                        url: '/get-activities', // Laravel route for fetching activities
                        type: 'GET',
                        data: {
                            destination_id: destinationId
                        },
                        success: function(response) {
                            let activityCheckboxes = "";
                            response.activities.forEach(activity => {
                                // Check if the activity was previously selected (checked)
                                let isChecked = checkedActivities.includes(activity.title) ?
                                    'checked' : '';
                                activityCheckboxes += `
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="activities[${rowIdx}][]" value="${activity.title}" id="activity-${rowIdx}-${activity.id}" ${isChecked}>
                                <label class="form-check-label" for="activity-${rowIdx}-${activity.id}">
                                    ${activity.title}
                                </label>
                            </div>`;
                            });
                            $(activityDiv).html(activityCheckboxes);
                        },
                        error: function() {
                            $(activityDiv).html(
                                "<p class='text-danger'>Error fetching activities.</p>");
                        }
                    });
                } else {
                    $(activityDiv).html("");
                }
            }

            // Handle destination change event
            $(document).on("change", ".destination", function() {
                let destinationId = $(this).val();
                let rowIdx = $(this).closest("tr").index(); // Get the row index
                let activityDiv = $(this).closest("tr").find(".activity-list");
                // Get checked activities from the row's data attribute
                let checkedActivities = $(this).closest("tr").data("activities") || [];
                fetchActivities(destinationId, activityDiv, rowIdx, checkedActivities);
            });

            // Add new row dynamically
            $(document).on("click", ".add-row", function() {
                let newRow = `<tr>
            <td>
                Date <input class="form-control" type="date" required name="date[${rowIndex}]">
                <input type="hidden" name="day[${rowIndex}]" value="${rowIndex + 1}">
            </td>
            <td>
                Destination
                <select class="form-control select2 destination" name="destination[${rowIndex}]">
                    <option value="">Select Destination</option>
                    @foreach ($destinations as $des)
                        <option value="{{ $des->id }}">{{ $des->title }}</option>
                    @endforeach
                </select>
            </td>
            <td>
                <div class="activity-list"></div> <!-- Activity checkboxes will be appended here -->
            </td>
            <td>
                <textarea class="form-control" name="note[${rowIndex}]"></textarea>
            </td>
            <td>
                <input class="form-control" type="text" name="hotel[${rowIndex}]">
                 <br>
                  <select class="form-control mt-2" name="basis[${rowIndex}]">
                                                                <option value="">Select Basis</option>
                                                                <option value="Bed & Breakfast Basis">Bed & Breakfast Basis</option>
                                                                <option value="Half Board Basis (Breakfast & Dinner)">Half Board Basis (Breakfast & Dinner)</option>
                                                                <option value="Full Board Basis (All 3 Meals)">Full Board Basis (All 3 Meals)</option>
                                                                <option value="Breakfast + Complimentary Dinner">Breakfast + Complimentary Dinner</option>
                                                            </select>
            </td>
            <td>
                <button type="button" class="btn btn-danger remove-row">Remove</button> <button type="button" class="btn btn-success add-row">Add
                                                                Row</button>
            </td>
        </tr>`;

                $("#dynamic-table tbody").append(newRow);
                rowIndex++;

                // Reinitialize Select2 for new row
                $(".select2").select2();
            });

            // Remove row
            $(document).on("click", ".remove-row", function() {
                $(this).closest("tr").remove();
            });

            // Fetch activities for existing rows when the page loads
            $("#dynamic-table tbody tr").each(function(index, row) {
                let destinationId = $(row).find(".destination").val();
                let activityDiv = $(row).find(".activity-list");

                // Get the pre-checked activities from data-activities attribute
                let checkedActivities = $(row).data("activities") || [];
                fetchActivities(destinationId, activityDiv, index, checkedActivities);
            });
        });
    </script>




    <!-- <script>
        $(document).ready(function() {


            var i = 0; // Initialize i to 0
            var d = 1;

            // Add Row button click event
            $(document).ready(function() {
                // Event delegation for dynamically added elements
                $('#dynamic-table').on('click', '.delete-row', function() {
                    $(this).closest('tr').remove();
                });



                $('#dynamic-table').on('click', '.add-row', function(event) {
                    event.preventDefault();
                    // Create a new row
                    var i = $('#dynamic-table tbody tr').length; // Get the current number of rows
                    var d = i + 1; // Increment day value

                    var newRow = $('<tr>');

                    // Add input fields to the row
                    newRow.append(
                        '<td>Date<input class="form-control" type="date" required name="date[' +
                        i +
                        ']"> <input type="hidden" name="day[' + i + ']" value="' + d +
                        '">   </td>'
                    );
                    newRow.append(
                        '<td>Destination <input class="form-control pac-target-input" type="text" required name="h_place[' +
                        i +
                        ']">  </div></td>'
                    );
                    newRow.append('<td><input class="form-control" type="text" name="note[' + i +
                        ']"></td>');
                    newRow.append(
                        '<td><button class="delete-row btn btn-danger">Delete</button> <button class="btn add-row btn-success" >Add Row</button></td></td>'
                    );


                    // Append the new row to the table body
                    $('#dynamic-table tbody').append(newRow);

                    // Initialize Autocomplete for the new row
                    initializeAutocompleteForNewRow(newRow);
                });
            });
        });
    </script> -->
    <script>
        $(document).ready(function() {
            t = 0;
            $('#add-invoice-row').click(function() {
                event.preventDefault();
                t++;

                const newRow = `
                    <tr>
                        <td><input class="form-control" type="text" required name="invoice[${t}]"></td>
                        <td><input class="form-control" type="number" required step="any" name="amount[${t}]"></td>
                        <td><button class="delete-row btn-danger btn">Delete</button></td>
                       
                    </tr>
                `;
                $('#dynamic-invoice tbody').append(newRow);
            });

            // Event delegation for dynamically added elements
            $('#dynamic-invoice').on('click', '.delete-row', function() {
                $(this).closest('tr').remove();
            });


        });
    </script>

    <script>
        $(document).ready(function() {

            var formSubmitted = false;


            $('#myForm').submit(function(event) {

                if (formSubmitted) {

                    event.preventDefault();

                } else {

                    formSubmitted = true;

                    $('#submitBtn').attr('disabled', true);
                }
            });
        });
    </script>
@endsection
