@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Hotel Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Hotel</a>
                                    </li>
                                    <li class="breadcrumb-item active">Edit Hotel</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Add Hotel</h4>

                                <form action="/hotel-update/{{$data->id}}" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{$data->title}}"
                                                name="name" required>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{$data->price}}"
                                                name="price" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Location</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{$data->location}}"
                                                name="location" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Rooms / Beds Type</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{$data->rooms}}"
                                                name="rooms" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Stars</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="number" min="1" max="5" value="{{$data->stars}}"
                                                name="stars" required>
                                        </div>
                                    </div>


                                 
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Main
                                            Image</label>
                                        <div class="col-sm-10">
                                            <input type="file" accept="image/*" value="" name="mainimage">
                                        </div>
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Previous Main
                                            Image</label>
                                        <div class="col-sm-10 diplayimg">
                                            <img src="{{ asset('thumbnails/' . $data->thumbnail) }}" width="150"
                                                height="auto" alt="">
                                            <P>only if you need to update add a new main Image</P>
                                        </div>
                                    </div>





                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Body</label>
                                        <div class="col-sm-10">
                                            <textarea  class="form-control"  name="body" id="" cols="30" rows="10">{{$data->description}}</textarea>
                                     
                                        </div>
                                    </div>






                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
    @endsection
