@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Holidays Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Holidays</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Holidays</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row justify-content-center mt-5">
                    <div class="col-md-8 col-lg-6">
                        <div class="card shadow rounded-3">
                            <div class="card-body ">

                                <h4 class="mb-4 text-primary font-weight-bold">📅 Import Mercantile Holidays</h4>

                                <form action="{{ route('holidays.import') }}" method="POST" enctype="multipart/form-data">
                                    @csrf

                                    <div class="form-group">
                                        <label for="file" class="font-weight-medium mb-2">Select CSV or Excel
                                            File</label>
                                        <input type="file" name="file" id="file" class="form-control-file"
                                            required>
                                    </div>

                                    <button type="submit" class="btn btn-primary mt-3 px-4">
                                        <i class="fas fa-upload"></i> Import
                                    </button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                var i = 0;


                function initSummernote(element) {
                    element.summernote({
                        height: 300,
                        minHeight: null,
                        maxHeight: null,
                        focus: true
                    });
                }

                $("#addRow").click(function(event) {
                    event.preventDefault();
                    i++; // Increment i
                    var newRow = '<tr>' +
                        '<td><input type="text" class="form-control" name="inputfield[' + i + '][day]"></td>' +
                        '<td><input type="text" class="form-control" name="inputfield[' + i +
                        '][title]"></td>' +
                        '<td><textarea name="inputfield[' + i +
                        '][description]" class="form-control summernote" id="" cols="50" rows="1"></textarea></td>' +
                        '<td><button class="deleteRow btn btn-danger">Delete</button></td>' +
                        '</tr>';
                    $("#qaTable tbody").append(newRow);


                    var newlyAddedTextarea = $("#qaTable tbody tr:last-child .summernote");
                    initSummernote(newlyAddedTextarea);
                    console.log(i);
                });

                $(document).on("click", ".deleteRow", function() {
                    $(this).closest("tr").remove();
                });


                initSummernote($(".summernote"));
            });
        </script>
    @endsection
