@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Package Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Package</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Package</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Add Package</h4>

                                <form action="/update-package/{{ $data->id }}" enctype="multipart/form-data"
                                    method="post">
                                    @csrf
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{ $data->title }}"
                                                name="name" required>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{ $data->price }}"
                                                name="price">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Discount
                                            Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{ $data->discount }}"
                                                name="discount">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Night</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" value="{{ $data->night }}"
                                                name="night" required>
                                        </div>
                                    </div>



                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Main
                                            Image</label>
                                        <div class="col-sm-10">
                                            <input type="file" accept="image/*" name="mainimage">
                                        </div>
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Previous Main
                                            Image</label>
                                        <div class="col-sm-10 diplayimg">
                                            <img src="{{ asset('thumbnails/' . $data->thumbnail) }}" width="150"
                                                height="auto" alt="">
                                            <P>only if you need to update add a new main Image</P>
                                        </div>
                                    </div>






                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Description</label>
                                        <div class="col-sm-10">
                                            <textarea required name="description" class="form-control summernote" id="" cols="30" rows="10">
                                          {!! $data->description !!}
                                            </textarea>

                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Price
                                            Include</label>
                                        <div class="col-sm-10">
                                            <textarea required name="include" class="form-control summernote" id="" cols="30" rows="10">
                                                {!! $data->includes !!}
                                            </textarea>

                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Itinerary</label>
                                        <div class="col-sm-10">

                                            <table class="table table-bordered mb-0" id="qaTable">

                                                <thead>
                                                    <tr>
                                                        <th>Day</th>
                                                        <th>Title</th>
                                                        <th>Description</th>
                                                        <th>Action <button class="btn btn-primary"
                                                                id="addRow">Add</button>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($itineray as $item)
                                                        <tr>
                                                            <td><input required type="text" class="form-control"
                                                                    value="{{ $item->day }}"
                                                                    name="inputfilde[{{ $loop->index }}][day]"></td>
                                                            <td><input required type="text" class="form-control"
                                                                    value="{{ $item->title }}"
                                                                    name="inputfilde[{{ $loop->index }}][title]"></td>
                                                            <td>
                                                                <textarea name="inputfilde[{{ $loop->index }}][description]" class="form-control summernote" id=""
                                                                    cols="50" rows="1"> {!! $item->description !!}
                                               </textarea>


                                                            </td>
                                                            <td><button class="deleteRow btn btn-danger">Delete</button>
                                                            </td>
                                                        </tr>
                                                        @php
                                                            $last = 0;
                                                            $last = $loop->last ? $loop->index : $last;
                                                        @endphp
                                                    @endforeach



                                                </tbody>
                                            </table>
                                        </div>
                                    </div>




                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                var i = {{ $last }}; // Declare and initialize i

                // Function to initialize Summernote for a specific element
                function initSummernote(element) {
                    element.summernote({
                        height: 300, // set editor height
                        minHeight: null, // set minimum height of editor
                        maxHeight: null, // set maximum height of editor
                        focus: true // set focus to editable area after initializing summernote
                    });
                }

                $("#addRow").click(function(event) {
                    event.preventDefault();
                    i++; // Increment i
                    var newRow = '<tr>' +
                        '<td><input required type="text" class="form-control" name="inputfilde[' + i + '][day]"></td>' +
                        '<td><input required type="text" class="form-control" name="inputfilde[' + i +
                        '][title]"></td>' +
                        '<td><textarea name="inputfilde[' + i +
                        '][description]" class="form-control summernote" id="" cols="50" rows="1"></textarea></td>' +
                        '<td><button class="deleteRow btn btn-danger">Delete</button></td>' +
                        '</tr>';
                    $("#qaTable tbody").append(newRow);

                    // Initialize Summernote for the newly added textarea
                    var newlyAddedTextarea = $("#qaTable tbody tr:last-child .summernote");
                    initSummernote(newlyAddedTextarea);
                    console.log(i);
                });

                $(document).on("click", ".deleteRow", function() {
                    $(this).closest("tr").remove();
                });

                // Initialize Summernote for existing textareas on page load
                initSummernote($(".summernote"));
            });
        </script>
    @endsection
