@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Add Driver</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Clients</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Driver</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div id="map" style="height: 500px; width: 100%;margin-bottom:60px;"></div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">





                                <div class="dynamic-table">
                                    <table class="table table-bordered responsive" id="dynamic-table">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Booking</th>
                                                <th>Special Note</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($hotels as $index => $hotel)
                                                <tr>
                                                    <td>
                                                        {{ $hotel->date }} <br>
                                                    </td>
                                                    <td>



                                                        Hotel:{{ $hotel->hotel }}<br>
                                                        Contact:{{ $hotel->h_contact }}<br>
                                                        Address: {{ $hotel->h_address }}<br>
                                                        Price:{{ $hotel->h_price }}<br>
                                                        Destination:{{ $hotel->h_place }}<br>
                                                    </td>
                                                    <td>

                                                        {{ $hotel->h_note }}
                                                    </td>

                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <form action="/driver-job" method="post">
                                    @csrf

                                    <div class="form-group row">
                                        <label for="package" class="col-sm-2 col-form-label">Driver
                                        </label>
                                        <div class="col-sm-10">
                                            <select class="form-control" name="driver" id="driver">
                                                <option value="">Select Driver</option>
                                                @foreach ($drivers as $driver)
                                                    <option value="{{ $driver->id }}"
                                                        @if ($driverplan->driverid == $driver->id) selected @endif>
                                                        {{ $driver->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="package" class="col-sm-2 col-form-label">Additional Driver
                                        </label>
                                        <div class="col-sm-10">

                                            <select class="form-control" name="additionaldriver" id="">
                                                <option value="">Select Driver</option>
                                                @foreach ($drivers as $driver)
                                                    <option value="{{ $driver->id }}"
                                                        @if ($driverplan->additionaldriver == $driver->id) selected @endif>
                                                        {{ $driver->name }}
                                                    </option>
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="price" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="hidden" name="tourbid"
                                                value="{{ $data->id }}" placeholder=" ">
                                            <input class="form-control" type="text" id="price" name="ride"
                                                value="{{ $driverplan->ride }}" placeholder=" ">
                                        </div>
                                    </div>

                                    <button class="btn btn-success" type="submit">submit</button>
                                </form>







                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <?php
        $itineraryArray = json_decode($data->itinerary, true);
        $itineraryJSON = json_encode($itineraryArray);
        ?>
        <script>
            var map;
            var directionsService;
            var directionsRenderer;
            var locationNames = <?php echo $itineraryJSON; ?>;

            console.log(locationNames);

            function initMap() {
                map = new google.maps.Map(document.getElementById("map"), {
                    zoom: 5,
                });

                directionsService = new google.maps.DirectionsService();
                directionsRenderer = new google.maps.DirectionsRenderer({
                    map: map,
                });

                updateDirections();
            }

            function updateDirections() {
                var origin = locationNames[0];
                var destination = locationNames[locationNames.length - 1];
                var waypoints = locationNames.slice(1, -1);

                var waypointsArray = waypoints.map(function(waypoint) {
                    return {
                        location: waypoint,
                        stopover: true,
                    };
                });

                var request = {
                    origin: origin,
                    destination: destination,
                    waypoints: waypointsArray,
                    travelMode: google.maps.TravelMode.DRIVING,
                };

                directionsService.route(request, function(result, status) {
                    if (status == google.maps.DirectionsStatus.OK) {
                        directionsRenderer.setDirections(result);
                    }
                });
            }
        </script>
        <script>
            function loadScript() {
                var script = document.createElement("script");
                script.src =
                    "https://maps.googleapis.com/maps/api/js?key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4&libraries=places&callback=initMap";
                script.async = true;
                document.head.appendChild(script);
            }

            window.onload = loadScript;
        </script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    @endsection
