<!DOCTYPE html>
<html>

<head>
    <style>
        /* Add inline styles for email compatibility */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .invoice {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }

        .header-table {
            width: 100%;
            border-collapse: collapse;
        }

        .header-row {
            width: 100%;
        }

        .invoice-header-cell {
            text-align: end;
            width: 50%;
        }

        .logo-container-cell {
            text-align: right;
            width: 50%;
        }

        .logo {
            max-width: 100px;
            height: auto;
            object-fit: cover;
        }

        .site {
            margin-left: 10px;
        }

        .bill-to {
            margin-top: 20px;
        }

        .details-table {
            margin-top: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 0;
            text-align: left;
            padding: 8px;
        }

        th {
            background-color: #f2f2f2;
        }

        .footer {
            margin-top: 20px;
            text-align: center;
        }

        td.logo-cell {
            width: 20px;
        }

        .header-table {
            width: 100%;
            border: 0;
            /* Remove border */
        }

        td.pk-deatil {
            padding-bottom: 60px;
        }
    </style>
</head>

<body>
    <?php
        $tour = \App\Models\TourBooking::where('id',$id)->first();
        $client = \App\Models\Client::where('id', $tour->clientid)->first();
    ?>
    <div class="invoice">
        <table class="header-table">
            <tr class="header-row">
                <td class="logo-cell">
                    <img style="height: 125px" class="logo" src="https://lankagetaways.com/images/Lanka_Getaways.jpeg"
                        alt="" />
                </td>
                <td class="cm-address">
                    <div class="site">
                        <h4 class="">LANKA GETAWAYS</h4>
                        <p>
                            No. 86, Station Road,<br />
                            Palangathure, <br />
                            Kochchikade, <br />
                            Sri Lanka, <br />
                            11540
                        </p>
                    </div>
                </td>
                <td class="invoice-header-cell">
                    <p>Invoice#: <?php echo e($tour->invoice); ?></p>
                    <p>
                        Issue Date: <br />
                        
                        <?php echo e(\Carbon\Carbon::parse($tour->created_at)->format('Y-m-d')); ?>

                    </p>
                </td>
            </tr>
        </table>
        <hr />
        <p>
            As you embark on this incredible journey with us, please rest assured
            that we are here to support you every step of the way. Should you have
            any questions, special requests, or require assistance at any point, our
            dedicated customer support team is just a phone call or email away. Your
            satisfaction is our top priority, and we are committed to going above
            and beyond to make your adventure truly exceptional. Once again, thank
            you for choosing LANKA GETAWAYS. We are genuinely honored to be a part
            of your travel plans and are eagerly looking forward to providing you
            with a memorable experience that will stay with you for a lifetime. Get
            ready for an incredible journey filled with extraordinary moments and
            unforgettable memories!
        </p>
        <table class="bill-to">
            <tr>
                <td class="to">
                    <hr />
                    <h5>BILL TO</h5>
                    <?php echo e($client->name); ?><br />
                    <?php echo e($client->country); ?> <br />
                    
                    Email: <?php echo e($client->email); ?>

                </td>
                <td class="pk-deatil">
                    <hr />
                    <h5>Details</h5>
                    <?php echo e($tour->deatil); ?>

                </td>
            </tr>
        </table>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th style="text-align: right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $invoice = \App\Models\Invoice::where('tourb_id', $id)->get();
                ?>


                

                <?php $__currentLoopData = $invoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($invoice->detail); ?><br />
                        </td>
                        <td style="text-align: right"><?php echo e($invoice->amount); ?> USD</td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="border-top: 1px solid black;">
                    <td>Subtotal</td>
                    <td style="text-align: right"><?php echo e($tour->subtotal); ?> USD</td>
                </tr>
                <tr>
                    <td>Pre-Paid</td>
                    <td style="text-align: right"><?php echo e($tour->prepaid); ?> USD</td>
                </tr>
                <tr style="border-top: 1px solid black;">
                    <td>Total Due</td>
                    <td style="text-align: right"><?php echo e($tour->total_due); ?> USD</td>
                </tr>
            </tbody>
        </table>
        <div class="footer">
            <b>
                <p>
                    THIS IS A COMPUTER – GENERATED DOCUMENT. NO SIGNATURE IS REQUIRED
                </p>
            </b>
        </div>
    </div>
</body>

</html>
<?php /**PATH F:\lgw\resources\views/emails/invoice.blade.php ENDPATH**/ ?>