<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>Lankan Travel Desk | Admin</title>
    <meta content="Responsive admin theme build on top of Bootstrap 4" name="description" />
    <meta content="Themesdesign" name="author" />
    <!-- <link rel="shortcut icon" href="../dash_assets/images/favicon.ico"> -->

    <link href="../plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">

    <link href="../dash_assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="../dash_assets/css/metismenu.min.css" rel="stylesheet" type="text/css">
    <link href="../dash_assets/css/icons.css" rel="stylesheet" type="text/css">
    <link href="../dash_assets/css/style.css" rel="stylesheet" type="text/css">

</head>

<body>
    <div class="accountbg"></div>

    <!-- Begin page -->
    <div class="home-btn d-none d-sm-block">
        <a href="/" class="text-white"><i class="mdi mdi-home h1"></i></a>
    </div>

    <div class="wrapper-page">

        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-5">
                    <div class="card card-pages shadow-none mt-4">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="card-body">
                            <div class="text-center mt-0 mb-3">
                                <a href="<?php echo e(route('homepage')); ?>" class="logo logo-admin">
                                    <img src="<?php echo e(asset('img/logo.svg')); ?>" class="mt-3" alt="" height="26">
                                </a>
                                <p class="text-muted w-75 mx-auto mb-4 mt-4">Enter your email address and password to
                                    access admin panel.</p>
                            </div>

                            <form method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>


                                <div class="form-group">
                                    <div class="col-12">
                                        <label for="username">Username</label>
                                        <input class="form-control" type="text" required="" id="username"
                                            type="email" name="email" :value="old('email')" placeholder="Username">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-12">
                                        <label for="password">Password</label>
                                        <input class="form-control" type="password" required="" id="password"
                                            name="password" required autocomplete="current-password"
                                            placeholder="Password">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-12">
                                        <div class="checkbox checkbox-primary">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                                <label class="custom-control-label" for="customCheck1"> Remember
                                                    me</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group text-center mt-3">
                                    <div class="col-12">
                                        <button class="btn btn-primary btn-block waves-effect waves-light"
                                            type="submit">Log In</button>
                                    </div>
                                </div>

                                



                            </form>

                        </div>

                    </div>

                </div>
            </div>
            <!-- end row -->
        </div>
    </div>



    <script src="../dash_assets/js/jquery.min.js"></script>
    <script src="../dash_assets/js/bootstrap.bundle.min.js"></script>
    <script src="../dash_assets/js/metismenu.min.js"></script>
    <script src="../dash_assets/js/jquery.slimscroll.js"></script>
    <script src="../dash_assets/js/waves.min.js"></script>

    <script src="../plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>



    <!-- App js -->
    <script src="../dash_assets/js/app.js"></script>


</body>

</html>
<?php /**PATH F:\lgw\resources\views/auth/login.blade.php ENDPATH**/ ?>