<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tour Itinerary</title>

    <style>
        .gs li {
            margin-left: 0px !important;
        }

        * {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 10pt;
        }
      
    @media (max-width: 600px) {
        .responsive-img {
            width: 50px !important; /* Adjust size for mobile */
        }
    }

    </style>
</head>

<body style="width: 100%; border: 1px solid #ddd; font-family: Arial, sans-serif; margin: 0; padding: 0;">
    <?php
        $quotation = App\Models\Quotation::where('id', $id)->first();

        $rows = App\Models\QuotationRow::where('quotations_id', $quotation->id)->get();
        $user = \App\Models\Client::where('id', $quotation->clientid)->first();
        // $qa = App\Models\QuotationActivity::where('id', $quotation->clientid)->first();
    ?>

    <div style="text-align: center; margin-bottom: 5px;margin-top: 50px;">
        <img src="https://lankagetaways.com/images/Lanka_Getaways.jpeg" class="responsive-img " alt="Company Logo" style="max-width: 150px;">
    </div>
    <div style="text-align: left; margin-bottom: 20px;">
        <img style="max-width: 150px !important;margin-left: 10px;" class="responsive-img " src="https://lankagetaways.com/images/emailsp.png"
            alt="Company Logo" >
    </div>
    <table style=" padding: 15px; font-family: Arial, sans-serif;">

        <tr>
            <td colspan="2" style="padding: 10px; font-size: 18px; font-weight: bold;">
                Customer Name: Mr/Mrs/Ms/Dr. <?php echo e($user->name ?? 'N/A'); ?>

            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 10px;">
                IN RESPONSE TO THE INQUIRY THE FARE AND THE DETAILS REGARDING YOUR GETAWAY IS MENTIONED BELOW.
            </td>
        </tr>
        <?php if($quotation->tour_type == 't-package'): ?>
            <tr>
                <td colspan="2" style="padding-top: 10px;">
                    <strong>Duration of the Dream Tour:</strong> <?php echo e($rows->first()->date); ?> to <?php echo e($rows->last()->date); ?>

                </td>
            </tr>
            <tr>
                <td colspan="2" style="padding-top: 20px;">
                    <h3 style=" text-decoration: underline;">Tour Itinerary</h3>

                    <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div style="padding-top: 10px;">
                            <?php
                                $des = App\Models\Destination::where('id', $details->destination)->first();
                            ?>

                            <strong><?php echo e($details->date); ?> - <?php echo e($des->title); ?></strong>
                            <?php
                                $qa = App\Models\QuotationActivity::where('row_id', $details->id)->get();
                            ?>

                            <ul
                                style="text-align: left; padding-left: 0px; margin-left: 0; list-style-position: inside;">
                                <?php $__currentLoopData = $qa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activitys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($activitys->activity); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                             <?php if($details->hotel !== null): ?>
                            <br>
                            <strong>Overnight Stay:</strong> <?php echo e($details->hotel); ?>

                        <?php endif; ?>

                            <?php if($details->note !== null): ?>
                                <br>
                                <span><?php echo e($details->note); ?></span>
                            <?php endif; ?>

                            <?php if($details->basis !== null): ?>
                                <br>
                                <span><?php echo e($details->basis); ?></span>
                            <?php endif; ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
            </tr>
        <?php else: ?>
            <tr>
            <tr>
                <td colspan="2" style="padding-top: 10px;">
                    <strong>Duration of the Dream Tour:</strong> <?php echo e($quotation->tour_from); ?> to
                    <?php echo e($quotation->tour_to); ?>

                </td>
            </tr>
            <tr>
                <td colspan="2" style="padding-top: 10px;">
                    <span style="text-decoration: underline">Tour Itinerary</span>
                </td>
            </tr>
            <td colspan="2" style="padding-top: 20px;">
                <h3>Hello Travel Enthusiast</h3>
                <p>
                    At Lanka Getaways, we specialize in creating bespoke travel experiences tailored to your unique
                    preferences. Whether you're dreaming of discovering hidden gems, indulging in local cuisine, or
                    unwinding on sun-kissed shores, we're here to curate your perfect adventure.
                </p>
                <p>
                    <strong>Craft Your Own Itinerary:</strong> You have the freedom to design your ideal trip. Simply
                    hit reply to this email or connect with our tour experts via WhatsApp at +94 77 386 6402. Our team
                    is dedicated to providing expert guidance and support to ensure your journey is everything you
                    envision.
                </p>
                <p>
                    <strong>Explore Pre-Planned Options:</strong> For those seeking ready-made adventures, explore our
                    diverse range of pre-planned itineraries designed to showcase the essence of Sri Lanka. Browse
                    through our curated collection of tours at Lanka Getaways' Package Tours at <a
                        href="https://lkgetaways.com/tour-packages" target="_blank">https://lkgetaways.com/tour-packages
                    </a>and find the perfect match for your
                    travel style. .
                </p>
            </td>
            </tr>
        <?php endif; ?>
        <!-- Economy and Luxury Vehicle Table -->
        <tr>
            <td colspan="2" style="padding-top: 10px;">
                <strong>Tour Inclusions for Your Peace of Mind:</strong>
                <ul>
                    <li>Comfortable air-conditioned transportation.</li>
                    <li>Services of experienced and trained tourist chauffeur.</li>
                    <li>Airport paging for a smooth start to your adventure.</li>
                    <li>Expressway tolls and parking fees included.</li>
                    <li>Fuel provided for your journey.</li>
                    <li>Chauffeur's food, accommodation, and bata included.</li>
                    <li>Complimentary water bottles and SIM card.</li>
                    <li>All applicable government taxes included.</li>
                    <?php if($quotation->tour_type == 't-package'): ?>
                        <li>Hotel Accommodation on the Stated Basis</li>
                    <?php endif; ?>

                </ul>
                <img style="width: 200px !important;margin-left: 10px;" src="https://lankagetaways.com/images/fee.png"
                    alt="no hiiden fee" style="max-width: 150px;">
            </td>
        </tr>

        <br>

        <?php if($quotation->vehicle == 'Car'): ?>
            <tr>
                <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Economy</td>
                <td style="border: 1px solid #000; padding: 10px;">Honda FIT Shuttle, Toyota Allion, Toyota Premio,
                    Nissan Tiida, Toyota Corolla
                </td>
            </tr>
            <tr>
                <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Luxury</td>
                <td style="border: 1px solid #000; padding: 10px;">Nissan Teana 250XV</td>
            </tr>
        <?php elseif($quotation->vehicle == 'Van'): ?>
            <tr>
                <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Economy</td>
                <td style="border: 1px solid #000; padding: 10px;">Toyota Hiace KDH or Nissan Caravan
                </td>
            </tr>
            <tr>
                <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Luxury</td>
                <td style="border: 1px solid #000; padding: 10px;">
                    Toyota Alphard, Toyota Esquire or Mercedez Benz Vito</td>
            </tr>
        <?php elseif($quotation->vehicle == 'Van (7 Pax & Above)'): ?>
            <tr>
                <td> Vehicle Offered For Your Dream Tour: Toyota Commuter or Nissan Caravan (High Roof)</td>


            </tr>
        <?php elseif($quotation->vehicle == 'Bus'): ?>
            <tr>
                <td>Vehicle Offered For Your Dream Tour: Toyota Coaster or Mitsubishi Rosa</td>

            </tr>
        <?php else: ?>
        <?php endif; ?>





        <!-- Tour Cost Table -->
        <tr>
            <td colspan="2" style="padding: 15px; font-weight: bold; font-size: 16px;">Total Cost For Your Dream
                Tour:</td>
        </tr>

        <tr>
            <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Economy</td>
            <td style="border: 1px solid #000; padding: 10px;"><?php echo e($quotation->economy_cost); ?></td>
        </tr>
        <tr>
            <td style="border: 1px solid #000; padding: 10px; font-weight: bold;">Luxury</td>
            <td style="border: 1px solid #000; padding: 10px;"><?php echo e($quotation->luxury_cost); ?></td>
        </tr>

        <!-- Prepayment Section -->
        <tr>
            <td colspan="2" style="padding: 15px; font-weight: bold; font-size: 16px;">
                Pre Payment Required (For Reservation): <?php echo e($quotation->pre_payment); ?>

            </td>
        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid #000; padding: 10px; font-weight: bold;">
                Secured Pre Payment Link
            </td>
        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid #000; padding: 10px;">
                <a href="<?php echo e($quotation->payment_link); ?>" target="_blank"><?php echo e($quotation->payment_link); ?></a>
            </td>
        </tr>

        <tr>
            <td>
                <img style="width: 200px !important;" src="https://lankagetaways.com/images/4.jpg" alt="Company Logo"
                    style="max-width: 150px;">
            </td>
        </tr>


        <!-- Payment Procedure -->
        <tr>
            <td colspan="2" style="padding: 15px; font-weight: bold;">Payment Procedure</td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 10px;">
                <ul>
                    <li>Confirm Your Reservation with a Prepayment (Advance): Secure Your Booking by Clicking on the
                        Safe and Secure Payment Link to Complete the Required Amount (50 USD).</li>
                    <li>Convenience at Arrival: You Have the Flexibility to Settle the Remaining Balance Upon Arrival,
                        Either in Cash or by Card
                    </li>
                </ul>
            </td>
        </tr>

        <!-- Instructions -->
        <tr>
            <td colspan="2" style="padding: 15px; font-weight: bold;">Instructions:</td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 10px;">
                <ol>
                    <li>There is no mileage limitation (Unlimited Kilometers). You are allowed to visit one specific
                        city per day. Your accommodation should be located in the city which you have planned to visit
                        on that specific day. Visits in and around the city where you are accommodated are covered in
                        the cost.</li>

                    <li>For further clarification, please feel free to ask our tour expert. Our experts can be reached
                        at <strong>0094 77 195 1694</strong> (Direct Calls and WhatsApp) or by replying to this email.
                    </li>

                    <li>Personalized Airport Welcome: Your chauffeurs will greet you at the airport paging area holding
                        a name board with your name, ensuring a smooth start to your journey.</li>

                    <li>Trusted Chauffeurs for Your Journey: Our drivers are certified by the Sri Lanka Tourism
                        Development Authority, committed to exemplary etiquette, and adhere to rigorous safety and
                        hygiene protocols.</li>

                    <li>Your Safety, Our Priority: Rest assured, our vehicles are fully insured, ensuring peace of mind
                        for both you and your fellow passengers.</li>

                    <li>Tailored Stays at Unbeatable Prices: Your dream hotel accommodation is just a request away, with
                        exclusive rates to match your preferences.</li>

                    <li>Indulge in Comfort: Our fleet of vehicles boasts full air-conditioning and provides cozy,
                        well-appointed seats for your ultimate enjoyment.</li>
                </ol>
            </td>
        </tr>

        <!-- Additional Information -->
        <tr>
            <td colspan="2" style="padding: 15px; "> <span style=" text-decoration: underline;">
                    Discover What Our Customers Have to Say: Check Out Our Reviews!</span></td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 10px;">
                <a
                    href="https://www.tripadvisor.co.uk/Attraction_Review-g297897-d15278876-Reviews-Lanka_Getaways-Negombo_Western_Province.html">
                    <img style="width: 200px !important;margin-left: 10px;"
                        src="https://lankagetaways.com/images/unnamed.png" alt="Company Logo" style="max-width: 150px;">
                </a>
            </td>
        </tr>
        <tr style="text-align: center; margin-bottom: 5px;margin-top: 50px">
            <td>
                <img style=" display: block; margin: 0 auto;" src="https://lankagetaways.com/images/unnamed2.png"
                    alt="centeremail image" style="">
            </td>

        </tr>
        <!-- Signature -->
        <tr>
            <td colspan="2" style="padding: 20px; font-size: 16px;">
                <strong>Warmest Regards,</strong><br>

                <em>Lankagetaways - Sales & Reservations Consultant</em> <br>
                Whatsapp or Direct Dial:0094 77 195 1694 <br><br>
            </td>
        </tr>
        <tr>
            <td style="padding: 0; font-size: 16px; vertical-align: top;">
                <img src="https://lankagetaways.com/images/Lanka_Getaways.jpeg" alt="Company Logo"
                    style="max-width: 150px;"> <br><br>
                <strong>Company Address:</strong>
                No.86, Station Road, Palangathure, Kochchikade (11540) <br>
                <strong>Hotline:</strong> +94 77 386 6402 <br>
                <strong>E-mail:</strong> info@lankagetaways.com <br>
                <strong>Web:</strong> <a href="https://www.lkgetaways.com" target="_blank">www.lkgetaways.com</a>
            </td>

        </tr>


    </table>

    <!-- Mobile Styling -->
    <style>
        @media screen and (max-width: 600px) {
            body {
                padding: 0;
            }

            div {
                padding: 5px;
            }

            table {
                font-size: 12px;
            }

            img {
                max-width: 100%;
                height: auto;
            }

            td {
                padding: 5px !important;
            }
        }
    </style>
</body>


</html>
<?php /**PATH /home/itinysaq/lankagetaways.com/resources/views/emails/quotation.blade.php ENDPATH**/ ?>