<?php $__env->startSection('title'); ?>
    <?php echo e('Dashboard page'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <?php echo e(session()->get('success')); ?>

                    </div>
                <?php endif; ?>


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Client itinerary list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Invoice</th>

                                            <th>Client</th>
                                            <th>Date</th>
                                            <th>Sub Total</th>
                                            <th>Due Payment</th>
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($data->invoice); ?></td>
                                                <td><?php echo e($data->name); ?></td>
                                                <td>

                                                    <?php

                                                        $lastRecord = \App\Models\HotelBooking::where('tourb_id', $data->id)
                                                            ->orderBy('date', 'DESC')
                                                            ->first();
                                                        $firstRecord = \App\Models\HotelBooking::where('tourb_id', $data->id)
                                                            ->orderBy('date', 'ASC')
                                                            ->latest()
                                                            ->first();

                                                    ?>
                                                    <?php echo e($firstRecord->date ?? ''); ?> to <?php echo e($lastRecord->date ?? ''); ?>




                                                </td>
                                                <td><?php echo e($data->subtotal); ?></td>
                                                <td><?php echo e($data->total_due); ?></td>
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="<?php echo e(route('edit-itinerary', $data->id)); ?>" role="button">Edit
                                                        Itinerary</a>
                                                    <?php if($data->total_due != 0): ?>
                                                        <a class="btn btn-danger edit" href=""
                                                            onclick="confirmPayment()" role="button">Full
                                                            payment</a>
                                                        <script>
                                                            function confirmPayment() {
                                                                if (confirm("Are you sure you want to make a full payment?")) {

                                                                    window.location.href = "<?php echo e(route('full-payment', ['id' => $data->id])); ?>";
                                                                }
                                                                event.preventDefault();
                                                            }
                                                        </script>
                                                    <?php endif; ?>

                                                    <?php if($data->status == '0'): ?>
                                                        <a class="btn btn-success edit"
                                                            href="<?php echo e(route('driver-itinerary', $data->id)); ?>"
                                                            role="button">Select Driver</a>
                                                    <?php elseif($data->status == '1'): ?>
                                                        <a class="btn btn-success edit"
                                                            href="<?php echo e(route('complete', $data->id)); ?>"
                                                            role="button">Complete</a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dash_layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\lgwedit\lgw\resources\views/admin/usertour-list.blade.php ENDPATH**/ ?>