@extends('partials.main')
@section('title')
    {{ 'TOUR PACKAGES' }}
@endsection
@section('content')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js"></script>
    <style>
        .tg-tourduration {
            width: 100%;
            float: none;
            color: #676767;
            margin: 0 0 12px;
            font-size: 13px;
            line-height: 13px;
            position: relative;
            padding: 3px 0 3px 25px;
        }

        #owl-demo .item {

            width: 100%;
            height: 500px;
            object-fit: cover;

        }

        /* to remove slide effect  css */
        .animated {
            -webkit-animation-duration: 0 ms !important;
            animation-duration: 0 ms !important;
            -webkit-animation-fill-mode: both !important;
            animation-fill-mode: both !important;
        }


        .fadeOut {
            -webkit-animation-name: fadeOut;
            animation-name: fadeOut;
        }

        @-webkit-keyframes fadeOut {
            0% {
                opacity: 0;
            }

            100% {
                opacity: 0;
            }
        }

        @keyframes fadeOut {
            0% {
                opacity: 0;
            }

            100% {
                opacity: 0;
            }
        }
    </style>

    <!--************************************
                                     Inner Banner Start
                                    *************************************-->
    <div class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="images/nuwaraeli.png">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"></div>
                </div>
            </div>
        </div>
    </div>
    <!--************************************
                                     Inner Banner End
                                    *************************************-->
    <!--************************************
                                     Main Start
                                    *************************************-->
    <main id="tg-main" class="tg-main tg-haslayout">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">
                        <div class="tg-tourbookingdetail">
                            <div class="tg-bookinginfo">
                                <h2>TRENDY TREASURES
                                    13 NIGHTS AND 14

                                    DAYS</h2>
                                <div>

                                </div>
                                <ul class="tg-tripinfo">
                                    <li><span style="color: #F44336;font-weight:600 ;  font-size: 18px;"
                                            class="tg-tourduration">14 Days 13 Nights</span></li>
                                    {{-- <li><span class="tg-tourduration tg-availabilty">Availability May 12</span></li> --}}
                                    {{-- <li><span class="tg-tourduration tg-location">Kandy,Negombo,galle</span></li>  --}}
                                    <li><span style="color: #ffdf12;font-weight:600;   font-size: 18px;"><i
                                                class="icon-coin-dollar2 "></i> 840 Onwards</span></li>

                                </ul>
                                <div class="tg-refundshare">
                                    {{-- <span class="tg-tourduration tg-location">Kandy,Negombo,galle</span></li>   --}}




                                </div>
                            </div>
                            <div class="tg-sectionspace tg-haslayout">
                                <div class="tg-themetabs tg-bookingtabs">
                                    <ul class="tg-themetabnav" role="tablist">
                                        <li role="presentation" class="active">
                                            <a href="#america" aria-controls="america" role="tab" data-toggle="tab">
                                                <span>Overview</span>
                                            </a>
                                        </li>
                                        <li role="presentation">
                                            <a href="#australia" aria-controls="australia" role="tab" data-toggle="tab">
                                                <span>Itinerary</span>
                                            </a>
                                        </li>
                                        {{-- <li role="presentation">
									<a href="#italy" aria-controls="italy" role="tab" data-toggle="tab">
										<span>location</span>
									</a>
								</li> --}}
                                        {{-- <li role="presentation">
                                            <a href="#london" aria-controls="london" role="tab" data-toggle="tab">
                                                <span>Reviews</span>
                                            </a>
                                        </li> --}}
                                        {{-- <li role="presentation">
                                            <a href="#india" aria-controls="india" role="tab" data-toggle="tab">
                                                <span>Gallery</span>
                                            </a>
                                        </li> --}}
                                    </ul>
                                    <div class="tab-content tg-themetabcontent">
                                        <div role="tabpanel" class="tab-pane active tg-overviewtab" id="america">
                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <h2>About this Package</h2>
                                                    <div class="tg-description">
                                                        <p>13-night adventure through the diverse landscapes of Sri Lanka,
                                                            where every moment is filled with discovery and wonder. This
                                                            comprehensive tour package takes you on a captivating journey,
                                                            covering the most iconic and essential destinations in the
                                                            country. Indulge in the sun-drenched beaches, feeling the soft
                                                            sand between your toes and the gentle sea breeze on your skin.
                                                            Conquer majestic mountain peaks, witnessing awe-inspiring vistas
                                                            that will take your breath away. Immerse yourself in the rich
                                                            history of Sri Lanka as you explore ancient temples, royal
                                                            palaces, and UNESCO World Heritage sites, unraveling the
                                                            fascinating tales of a bygone era. Journey through lush tea
                                                            gardens, savoring the flavors and aromas of world-renowned
                                                            Ceylon tea. In these 13 nights, experience the true essence of
                                                            Sri Lanka, where every moment is a treasure and every place
                                                            visit is a masterpiece. Get ready for an unforgettable
                                                            expedition that will leave you with lifelong memories and a deep
                                                            appreciation for the beauty and culture of this enchanting
                                                            island."</p>

                                                        <p>*Hotel Accommodation Can Be Arranged Upon Request (Hotel Prices
                                                            Not Included In The
                                                            Package Price)</p>
                                                    </div>
                                                </div>
                                                {{-- <div class="tg-box">
                                                    <h2>Guest access</h2>
                                                    <div class="tg-description">
                                                        <p>Proin condimentum fermentum nunc. Etiam pharetra, erat sed
                                                            fermentum feugiat, velit mauris egestas quam.</p>
                                                        <p>Maecenas sed diam eget risus varius blandit sit amet non magna.
                                                            Vivamus sagittis lacus vel augue Sed non mauris vitae;erat
                                                            consequat auctor eu in elit. Class aptent taciti sociosqu ad
                                                            litora torquent per conubia nostra.</p>
                                                        <ul class="tg-liststyle">
                                                            <li><span>Ipsum Amet Mattis Pellentesque</span></li>
                                                            <li><span>Ultricies Vehicula Mollis Vestibulum Fringilla</span>
                                                            </li>
                                                            <li><span>Condimentum Sollicitudin Fusce Vestibulum
                                                                    Ultricies</span></li>
                                                            <li><span>Sollicitudin Consectetur Quam Ligula Vehicula</span>
                                                            </li>
                                                            <li><span>Cursus Pharetra Purus Porta Parturient</span></li>
                                                        </ul>
                                                    </div>
                                                </div> --}}
                                            </div>
                                            {{-- <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-amentities">
                                                    <h3>Package Inclusions</h3>
                                                    <div class="tg-content">
                                                        <ul class="tg-liststyle">
                                                            <li><span>Pets allowed</span></li>
                                                            <li><span>Internet</span></li>
                                                            <li><span>Gym</span></li>
                                                            <li><span>Hot tub</span></li>
                                                            <li><span>Doorman</span></li>
                                                            <li><span>Wheelchair accessible</span></li>
                                                            <li><span>Pool</span></li>
                                                        </ul>
                                                        <ul class="tg-liststyle">
                                                            <li><span>Kitchen</span></li>
                                                            <li><span>Suitable for events</span></li>
                                                            <li><span>Dryer</span></li>
                                                            <li><span>Family/kid friendly</span></li>
                                                            <li><span>Cable TV</span></li>
                                                            <li><span>Wireless Internet</span></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div> --}}
                                            <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-priceinclude">
                                                    <h3>Price Includes</h3>
                                                    <div class="tg-content">
                                                        <ul class="tg-liststyle">
                                                            <li><span> Airport Pickup and Drop Off.</span></li>
                                                            <li><span> Transport Offered in a Comfortable Air Conditioned
                                                                    Vehicle.</span></li>
                                                            <li><span> Services of Our Well Trained Tourist
                                                                    Chauffeur.</span></li>
                                                            <li><span> Expressway Tolls.</span></li>
                                                            <li><span> Airport Paging Expenses.</span></li>
                                                            <li><span> Parking Fees.</span></li>
                                                            <li><span> Fuel Expenses.</span></li>
                                                            <li><span> Free Water Bottles (1 Litre Per Person Per
                                                                    Day)</span></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-amentities">
                                                    <h3>Tour Rules</h3>
                                                    <div class="tg-content">
                                                        <div class="tg-description">
                                                            <p>Maecenas sed diam eget risus varius blandit sit amet non
                                                                magna. Vivamus sagittis lacus vel augue Sed non mauris
                                                                vitae;erat consequat auctor eu in elit. Class aptent taciti
                                                                sociosqu ad litora torquent.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> --}}
                                        </div>
                                        <div role="tabpanel" class="tab-pane tg-itinerary" id="australia">
                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <div class="tg-accordion" role="tablist" aria-multiselectable="true">
                                                        <div class="tg-panel day1">
                                                            <h4>Day 1<span>Bandaranaike International Airport to
                                                                    Anuradhapura</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        Oh! To have the rare luck of exploring Sri Lanka in
                                                                        two whole weeks! The first of the
                                                                        destinations in your Sri Lanka vacation is
                                                                        Anuradhapura, one of the ancient capitals. The
                                                                        sacred city is brimming with stories to be
                                                                        discovered, which is why it is also a UNESCO
                                                                        world heritage site. The first historical site you
                                                                        visit in your Sri Lanka vacation package is
                                                                        Mihintale. The dodgy climb to Mihintale feels
                                                                        absolutely worthy as it greets you with a
                                                                        magnificent view along with insane winds. You
                                                                        discover the beauty of the ancient
                                                                        architecture in Ritigala Forest Monastery, Twin
                                                                        Baths (Kuttam Pokuna), and
                                                                        Ruwanweliseya! It’s still the first day of your Sri
                                                                        Lanka vacation, and you are already
                                                                        capturing everything you see!

                                                                    </p>



                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day2">
                                                            <h4>Day 2<span>Anuradhapura to Polonnaruwa</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        Polonnaruwa, a marvel of a place, is in Northern Sri
                                                                        Lanka. The city once served as the
                                                                        capital of the Kingdom of Polonnaruwa under the
                                                                        Chola Empire in the 10th century. This
                                                                        makes it the second most historic kingdom in Sri
                                                                        Lanka after Anuradhapura. <br> <br>

                                                                        The entire town has two sections - the development
                                                                        and infrastructure part called the
                                                                        Polonnaruwa new town and the Old Site with ancient
                                                                        remains and monarchical
                                                                        structures. <br> <br>

                                                                        The old part of the city is a UNESCO World Heritage
                                                                        site. It has numerous ruins dating back
                                                                        to 800 years comprising of tombs, temples, statues
                                                                        and stupas. Within the town, is the
                                                                        celebrated quadrangle, Gal Vihara – Buddhist 12th
                                                                        century rock temple, Archaeological
                                                                        museum, Polonnaruwa Vatadage – holds the relic of
                                                                        the tooth of Buddha, Rankot Vihara –
                                                                        a 12th century stupa, Hatadage - an ancient relic
                                                                        shrine and the Lankathilaka – a cathedral
                                                                        type Buddhist temple and many other statuettes
                                                                        dedicated to Lord Buddha. <br> <br>

                                                                        Another beauty is the wildlife in the Minneriya
                                                                        National Park dedicated to elephants. It
                                                                        has the most significant elephant gathering in the
                                                                        whole of Asia. A jeep safari there will
                                                                        show you around monkeys, iguana, crocodiles pelicans
                                                                        and various animals and birds in
                                                                        their natural habitat. The eerie ruins of
                                                                        Polonnaruwa are home to the Potgul vihara – an
                                                                        age-old library with domes for roofs that hold
                                                                        sacred books and a lecture theatre. The
                                                                        eternal city has beautiful landscapes for pictures.
                                                                        For instance, the Parakrama Samudra is
                                                                        one of the five reservoirs in Sri Lanka that has
                                                                        provided water to the people since the days
                                                                        of yore. <br> <br>

                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day3">
                                                            <h4>Day 3<span>Polonnaruwa to Sigiriya</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        Declared a world heritage site by UNESCO, Sigiriya
                                                                        serves as a fine example of ancient
                                                                        urban planning. Sigiriya is a significant site of
                                                                        the Cultural Triangle and perhaps Sri Lanka’s
                                                                        most iconic historical destination. The site, also
                                                                        known as Lion Rock, is recognized all over
                                                                        the world for the remains of the ancient Sigiriya
                                                                        Rock Fortress and its numerous
                                                                        enchanting and well-preserved attractions. The
                                                                        complex hydraulics system at the fortress
                                                                        enhances the site’s reputation as a beautiful
                                                                        example of classical city planning. <br> <br>

                                                                        It is located in the Matale district in the centre
                                                                        near the town called Dambulla. According
                                                                        to history, this site was chosen by the king Kasyapa
                                                                        to serve as his new capital. There is a
                                                                        huge gateway shaped like a lion and the place
                                                                        derives its name from this gateway. This
                                                                        place served as a Buddhist monastery until the 14th
                                                                        century. <br> <br>

                                                                        The fortress complex, constructed in the 5th
                                                                        century, includes attractions such as the royal
                                                                        gardens, one of the oldest landscaped gardens in the
                                                                        world, and the Mirror Wall, which is
                                                                        adorned with ancient graffiti. The highlight of the
                                                                        fortress is the colourful frescoes painted
                                                                        on the western face of the rock; it is believed that
                                                                        there were initially 500 such frescoes,
                                                                        but merely around 22 of them remain today. The
                                                                        gigantic Lion’s Paws greet visitors before
                                                                        the summit. At the peak are the ruins of the royal
                                                                        palace of King Kashyapa I, and 360-
                                                                        degree panoramas of the surrounding landscape.
                                                                        Sigiriya Museum at the foot of the rock
                                                                        has a plethora of artefacts related to Sigiriya on
                                                                        display for visitors seeking information
                                                                        regarding the site’s history. <br> <br>

                                                                        Another interesting archaeological site located
                                                                        nearby is Pidurangala, which houses the
                                                                        remains of a cave temple complex. Hiking to the
                                                                        summit of Pidurangala Rock offers
                                                                        stunning views of the Sigiriya Rock. Visit Sigiriya
                                                                        and explore the opulence, might and
                                                                        sophistication of the ancient kingdoms of Sri Lanka.
                                                                        <br>


                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day4">
                                                            <h4>Day 4<span>Sigiriya to Kandy</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        Kandy, Sri Lanka’s capital city of culture, is a
                                                                        city never to miss on a Sri Lanka vacation. On
                                                                        the fourth day of your Sri Lanka vacation package,
                                                                        you visit the most sacred place in Sri
                                                                        Lanka; the Temple of Tooth, which protects the tooth
                                                                        relics of Lord Buddha. It is the relic
                                                                        of the real Buddha! This sacred tooth is covered in
                                                                        boxes of gold and jewels, and
                                                                        surprisingly, there are no armed guards to protect
                                                                        it! You take a walk in the city full of
                                                                        restaurants with incredible flavors of Sri Lankan
                                                                        cuisine. This Sri Lanka vacation costs too
                                                                        low for what it gives! You listen to the soft
                                                                        chanting of hymns, inspiring artifacts, people
                                                                        with warm gestures, and the relaxing feel of a
                                                                        calming evening. At this point, there is
                                                                        nothing more you would ask from your Sri Lanka
                                                                        vacation. <br> <br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day5">
                                                            <h4>Day 5<span>Kandy to Nuwara Eliya</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>Nuwara Eliya is Sri Lanka&#39;s hill station famed
                                                                        for its tea production. With a multitude of
                                                                        gorgeous attractions ranging from waterfalls and tea
                                                                        plantations to gardens and lakes,
                                                                        Nuwara Eliya is the epitome of scenic beauty. Add to
                                                                        that the colonial-style buildings
                                                                        dotting the area, a golf course and the cold
                                                                        climate— and you&#39;ll feel like you have entered
                                                                        a world unlike Sri Lanka&#39;s iconic landscape; no
                                                                        wonder it is also called Little England! <br>

                                                                        Nuwara Eliya besides being the most important site
                                                                        for tea production also happens to be
                                                                        overlooked by the Pidurutalagala. This is the
                                                                        tallest mountain in Sri Lanka. This city enjoys
                                                                        an extremely temperate climate. Indeed this place
                                                                        happens to be the coolest part of Sri
                                                                        Lanka. <br>

                                                                        The most notable among Nuwara Eliya&#39;s sights is
                                                                        Lake Gregory, a stunning reservoir
                                                                        constructed in 1873; boat rides, jet skis and pony
                                                                        rides are relatively common at this
                                                                        typically tranquil lake. <br>

                                                                        The waterfalls in and around Nuwara Eliya include
                                                                        Lover&#39;s Leap Falls, Bomburu Ella Falls,
                                                                        St. Clair&#39;s Falls and Devon Falls. Victoria Park
                                                                        is a beautiful recreational area with several
                                                                        floral species and is a popular spot for
                                                                        birdwatching in the city. Another location for
                                                                        birdwatching and rare wildlife sightings is
                                                                        Galway&#39;s Land National Park. The numerous
                                                                        verdant tea plantations in Nuwara Eliya deserve a
                                                                        special mention; they are certainly one
                                                                        of the main draws of the city&#39;s tourism. <br>

                                                                        Nuwara Eliya is a start point for visiting Horton
                                                                        Plains National Park. The city is near the
                                                                        Hakgala Botanical Gardens, home to thousands of
                                                                        flora, and the Seetha Amman Temple,
                                                                        dedicated to the Hindu goddess Seetha. <br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day6">
                                                            <h4>Day 6 <span>Nuwara Eliya to Ella</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <p>
                                                                    There’s no wonder why Ella is in every Sri Lanka
                                                                    vacation package. You take the train from
                                                                    Nuwara Eliya to Ella, and you experience one of the most
                                                                    beautiful train rides in the
                                                                    world-what a streak of stunning views! You arrive at
                                                                    Ella and head straight to the awe-
                                                                    striking Nine Arch Bridge surrounded by emerald
                                                                    greenery. Your Sri Lanka vacation
                                                                    includes zip-lining over the neat tea fields, which is
                                                                    one to experience. A Sri Lanka
                                                                    vacation in Ella is never complete without a swim in the
                                                                    natural pools of Diyaluma Falls.
                                                                    As you feel the foamy water relaxing your whole body,
                                                                    you immerse in nature. You enjoy
                                                                    the light flurry of air as it gently kisses your cheeks
                                                                    as you walk around the beautiful
                                                                    village in the evening – perfection!
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day7">
                                                            <h4>Day 7<span>Ella to Udawalawe</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>Udawalawa National Park, the next destination of your
                                                                        incredible Sri Lanka vacation
                                                                        package: is stationed in the South Central region of
                                                                        the tropical island. On this day of your
                                                                        Sri Lanka vacation, you venture into the wilderness,
                                                                        away from the cold weather of
                                                                        luxurious Little England! You buckle up your seat
                                                                        belts because you know it is going to get
                                                                        rough and wild! For you, the main attractions of
                                                                        this wildlife sanctuary are Water Buffalo,
                                                                        Wild boar, different species of Deer, wild Asian
                                                                        Elephants, and exceptional birdlife. It is
                                                                        the perfect Sri Lanka vacation package for you. You
                                                                        visit the Elephant Transit Home and
                                                                        fall in love with the adorable and playful elephants
                                                                        who often try to peep into the safari
                                                                        jeeps! <br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>


                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <div id="tg-accordion" class="tg-accordion" role="tablist"
                                                        aria-multiselectable="true">


                                                        <div class="tg-panel day8">
                                                            <h4>Day 8<span>Udawalawe to Yala</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        You missed the sight of the magnificent leopards
                                                                        during the Udawalawa Safari. However,
                                                                        this Sri Lanka vacation package includes a tour back
                                                                        into the wilderness from a wildlife
                                                                        safari at Yala! You get in the jeep escorted by an
                                                                        experienced guide, and as the ride
                                                                        becomes adventurous, you get excited. Suddenly, a
                                                                        herd of gigantic wild elephants blocks
                                                                        your road, and you take out your camera and film the
                                                                        adventure! After all, the memories
                                                                        at Yala are too nerve-kicking to stay only with you;
                                                                        they are worth a share! Finally, you
                                                                        see the glorious leopards and the mesmerizing
                                                                        peacock dance. This Sri Lanka vacation
                                                                        package is surely a one of a kind. By the end of
                                                                        this Sri Lanka vacation, you fulfill your wish
                                                                        to sight-see the majestic leopards of Sri Lanka. –
                                                                        Lucky you!
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day9">
                                                            <h4>Day 9<span>Yala to Mirissa</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>Mirissa, what was a faint old beach town on the
                                                                        Southern of Sri Lanka has risen to be one
                                                                        of the most popular surfing and whale watching
                                                                        destination. The beach town is situated
                                                                        150 kms south of Colombo and is dotted with palm
                                                                        trees, blue waters and colourful boats
                                                                        adorning the shores. <br>

                                                                        Mirissa has a beautiful view along by the million
                                                                        things to do over here – Whale watching,
                                                                        Snorkelling, Surfing, Bodyboarding. The city offers
                                                                        the right balance between the calm
                                                                        days and lively nights by the beach. <br>

                                                                        The bright and lively coast has happy hours for a
                                                                        part of the day and candle-lit sea-food
                                                                        dinners once the sun sets. The clear waters bundled
                                                                        with turtles and aquatic life are a
                                                                        sight to behold. <br>

                                                                        From classic cocktail mixes to coconut induced
                                                                        delights, burgers from the beach shacks to
                                                                        kootu, rice and curry – Mirissa is a traveller’s
                                                                        paradise. A scooter ride away are the
                                                                        Weligama, Dalawella and Unawatuna beaches and if
                                                                        you’re lucky enough you’ll see how
                                                                        stilt fishing in the shallow waters. The Parrot
                                                                        rock, the iconic coconut island, Elephant
                                                                        transit home and Galle fort are some picturesque
                                                                        locations of this shoreline.<br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day10">
                                                            <h4>Day 10<span>Mirissa to Sinharaja</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        You wake up to the chirping of the birds and look
                                                                        through the window of your cozy hotel
                                                                        room. You smell the tropical fruit trees surrounding
                                                                        you in the lush forest. You are in
                                                                        Sinharaja, and it’s a beautiful morning full of
                                                                        life. Like all other destinations in our Sri
                                                                        Lanka vacation packages, the unlimited breakfast
                                                                        buffet takes you to the moon with its
                                                                        delicious Sri Lankan cuisine. You start trekking the
                                                                        jungle, and your Sri Lanka vacation just
                                                                        got better: You come across a natural water spring.
                                                                        After exploring the adventurous yet
                                                                        soul-touching Sinharaja forest, you walk through the
                                                                        beautiful Sinharaja village. The
                                                                        tropical weather is just right to chug some Sri
                                                                        Lankan Lion Beer, which foreigners love; the
                                                                        best way to end a chilly night of a Sri Lanka
                                                                        vacation.
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day11">
                                                            <h4>Day 11<span>Sinharaja to Galle</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>Tucked into the southwest coast of Sri Lanka, Galle
                                                                        is a major city and UNESCO World
                                                                        Heritage Site. Blessed with imposing Dutch-colonial
                                                                        buildings, ancient churches and
                                                                        mosques, blond beaches, mansions and museums, quirky
                                                                        boutiques, and a convivial
                                                                        seaside promenade, Galle attracts locals, foreign
                                                                        travellers, history buffs and nature lovers
                                                                        alike. <br> <br>

                                                                        Against the riveting ocean backdrop, Galle Fort and
                                                                        Lighthouse display awe-inspiring
                                                                        Victorian relics in the snazzy neighbourhood. This
                                                                        fortified city was founded by
                                                                        Portuguese colonists in the 16th century. Stone
                                                                        seawalls, built by the Dutch, encircle car-
                                                                        free streets with Portuguese and British
                                                                        architecture. Galle is also known for its pristine,
                                                                        tropic-riven beaches like Ahungalla Beach and
                                                                        Unawatuna Beach, where families and
                                                                        friends frolic in the surf. <br> <br>

                                                                        Some more prominent landmarks include the natural
                                                                        harbour, the Historical Mansion
                                                                        Museum, Flag Rock and Meeran Mosque. In addition,
                                                                        Galle International Stadium is
                                                                        acclaimed as one of the most picturesque cricket
                                                                        grounds worldwide. To round off your
                                                                        Galle tour, take home precious handicrafts, silk and
                                                                        trinkets from the Old Dutch Market
                                                                        and Galle Face Green Night Market. <br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day12">
                                                            <h4>Day 12<span>Galle to Hikkaduwa</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>
                                                                        Hikkaduwa finds itself nuzzled in the Galle district
                                                                        of South Western Sri Lanka, 2 hours
                                                                        away from Colombo. The beaches of Hikkaduwa have
                                                                        been visited since the 1970s for
                                                                        their vibrant nightlife and cuisine. The beaches are
                                                                        a surfer&#39;s delight and have a large coral
                                                                        reef, the Hikkaduwa Coral Sanctuary, which is
                                                                        favourable for scuba diving and snorkelling. <br>
                                                                        <br>

                                                                        Hikkaduwa has some of the best scuba diving in Sri
                                                                        Lanka with unique dive sites such as
                                                                        wreck dives and spectacular reef dives. It is also
                                                                        touted to have the second best surfing in
                                                                        Sri Lanka. <br> <br>

                                                                        The shore is lined up with restaurants, shacks and
                                                                        bars overlooking the sea. Narigama
                                                                        beach, Sea turtle hatching and rescue centre,
                                                                        Tsunami education centre &amp; museum,
                                                                        Gangarama Maha Vihara and the Hikkaduwa national
                                                                        park are the spectacular tourist
                                                                        sights here. <br> <br>

                                                                        You will find yourself enjoying a chilled cocktail
                                                                        on a deck in Hikkaduwa. Particularly
                                                                        corals, exotic fish and turtles are found aplenty in
                                                                        this resort town. There are numerous
                                                                        surfing schools, guesthouses and a quiet road
                                                                        perfect for long drives here. <br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tg-panel day13">
                                                            <h4>Day 13<span>Colombo</span>
                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">
                                                                    <p>After two weeks of touring around the pearl island
                                                                        for the lowest Sri Lanka vacation cost,
                                                                        a city tour around Colombo is a treat. As the
                                                                        commercial capital, Colombo is gifted with
                                                                        scenic beauty, some of the best restaurants, and
                                                                        shopping complexes on the island. You
                                                                        walk through the Pettah market, which gives the feel
                                                                        of the down-to-earth lifestyle of the
                                                                        city life in Sri Lanka. A Colombo travel package
                                                                        always has a stop at the floating market. In
                                                                        this Sri Lanka vacation package, you get the chance
                                                                        to learn how to cook traditional Sri
                                                                        Lankan cuisine. While the day remains to be
                                                                        bustling, nightlife in Colombo is one for the
                                                                        party animals! You enjoy this night of your Sri
                                                                        Lanka vacation beside the spectacular
                                                                        beach under the starry skies.<br>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>



                                                        <div class="tg-panel ady14">
                                                            <h4>Day 14<span>Drop Off to Bandaranaike International
                                                                    Airport</span>


                                                            </h4>
                                                            <div class="tg-panelcontent">
                                                                <div class="tg-description">

                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {{-- <div role="tabpanel" class="tab-pane tg-locationtab" id="italy">
                                            <div class="tg-box tg-location">
                                                <h3>The neighborhood</h3>
                                                <div class="tg-description">
                                                    <p>Curabitur blandit tempus porttitor. Lorem ipsum dolor sit amet,
                                                        consectetur adipiscing elit. Cras mattis consectetur purus sit amet
                                                        fermentum. Etiam porta sem malesuada magna mollis
                                                        euismod. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                                    </p>
                                                </div>
                                                <div id="tg-locationmap" class="tg-locationmap tg-map"></div>
                                            </div>
                                        </div> --}}
                                        {{-- <div role="tabpanel" class="tab-pane tg-reviewtab" id="london">
                                            <div class="tg-reviewsarea">
                                                <form class="tg-formtheme tg-formreviews">
                                                    <fieldset class="tg-filterby">
                                                        <div class="tg-durationrating">
                                                            <em>(3 Review)</em>
                                                            <span class="tg-stars"><span></span></span>
                                                        </div>
                                                        <span class="tg-select">
                                                            <select>
                                                                <option>Filter by</option>
                                                                <option>Rating</option>
                                                                <option>New</option>
                                                                <option>date</option>
                                                            </select>
                                                        </span>
                                                    </fieldset>
                                                    <fieldset class="tg-reviews">
                                                        <ul>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu.</p>
                                                                            <p>First, please don’t fall sick. However, if in
                                                                                case something does catchup with you, we
                                                                                will airlift you to hospital but your
                                                                                insurance will have to pay for this. Ulins
                                                                                aliquam massa nisl quis neque. Proin
                                                                                condimentum fermentum nunc. Etiam pharetra,
                                                                                erat sed fermentum feugiat, velit mauris
                                                                                egestas quam, ut liquam massa nisl quis
                                                                                neque.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>What a magical place, even better than I
                                                                                imagined! Teresa and Daniella were so
                                                                                helpful and awesome</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Very nice place</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu ad litora torquent per
                                                                                conubia nostra, per inceptos himenaeos.
                                                                                Mauris in erat justo First, please don’t
                                                                                fall sick. However, if in case something
                                                                                does catchup.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </fieldset>
                                                    <fieldset class="tg-formleavereview">
                                                        <div class="tg-leavereviewhead">
                                                            <h2>Leave your Comment</h2>
                                                            <div class="tg-durationrating">
                                                                <h3>Your Rating</h3>
                                                                <span class="tg-stars"><span></span></span>
                                                            </div>
                                                        </div>
                                                        <div class="tg-reviewformarea">
                                                            <div class="form-group">
                                                                <input type="text" name="fullname"
                                                                    class="form-control" placeholder="Full Name">
                                                            </div>
                                                            <div class="form-group">
                                                                <input type="email" name="email" class="form-control"
                                                                    placeholder="Email Address">
                                                            </div>
                                                            <div class="form-group">
                                                                <textarea placeholder>Your Comment</textarea>
                                                            </div>
                                                            <div class="form-group">
                                                                <a class="tg-btn" href="#"><span>submit</span></a>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </form>
                                            </div>
                                        </div> --}}
                                        <div role="tabpanel" class="tab-pane tg-gallerytab" id="india">
                                            <div class="tg-gallery">
                                                <ul>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/6-Reasons-Sri-Lanka-Should-Be-On-Your-Travel-Radar-This-Year.jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/6-Reasons-Sri-Lanka-Should-Be-On-Your-Travel-Radar-This-Year.jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (1).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (1).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--************************************
                                      Article Start
                                    *************************************-->
        {{-- <div class="tg-sectionspace tg-haslayout tg-bglight">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead tg-sectionheadvtwo">
                            <div class="tg-sectiontitle">
                                <h2>Latest Articles</h2>
                            </div>
                            <div class="tg-description">
                                <p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam consectetuer</p>
                            </div>
                        </div>
                    </div>
                    <div class="tg-posts">
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-01_3.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-02_1.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-03_2.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-04_1.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}
        <!--************************************
                                      Article End
                                    *************************************-->
    </main>
    <!--************************************
                                     Main End
                                    *************************************-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css"></script>
    <script src=""></script>
    <script>
        $(document).ready(function() {

            $("#owl-demo").owlCarousel({
                navigation: true,
                items: 1,
                loop: true,

                nav: false,
                autoplay: true,
                animateOut: 'fadeOut',
                animateIn: 'fadeIn',
            });

        });
    </script>
@endsection
