@extends('partials.main')
@section('title')
    {{ 'TOUR PACKAGES' }}
@endsection
@section('content')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js"></script>
    <style>
        #owl-demo .item {

            width: 100%;
            height: 500px;
            object-fit: cover;

        }

        /* to remove slide effect  css */
        .animated {
            -webkit-animation-duration: 0 ms !important;
            animation-duration: 0 ms !important;
            -webkit-animation-fill-mode: both !important;
            animation-fill-mode: both !important;
        }


        .fadeOut {
            -webkit-animation-name: fadeOut;
            animation-name: fadeOut;
        }

        @-webkit-keyframes fadeOut {
            0% {
                opacity: 0;
            }

            100% {
                opacity: 0;
            }
        }

        @keyframes fadeOut {
            0% {
                opacity: 0;
            }

            100% {
                opacity: 0;
            }
        }
    </style>

    <!--************************************
                             Inner Banner Start
                            *************************************-->
    <div class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/nuwaraeli.png">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"></div>
                </div>
            </div>
        </div>
    </div>
    <!--************************************
                             Inner Banner End
                            *************************************-->
    <!--************************************
                             Main Start
                            *************************************-->
    <main id="tg-main" class="tg-main tg-haslayout">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">
                        <div class="tg-tourbookingdetail">
                            <div class="tg-bookinginfo">
                                <h2>{{ $data->title }}</h2>
                                <ul class="tg-tripinfo">
                                    <li><span style="color: #F44336;font-weight:600 ;  font-size: 18px;"
                                            class="tg-tourduration">{{ $data->day }} Days {{ $data->night }}
                                            Nights</span></li>
                                    {{-- <li><span class="tg-tourduration tg-availabilty">Availability May 12</span></li> --}}
                                    {{-- <li><span class="tg-tourduration tg-location">Kandy,Negombo,galle</span></li>  --}}
                                    <li><span style="color: #ffdf12;font-weight:600;   font-size: 18px;"><i
                                                class="icon-coin-dollar2 "></i> {{ $data->price }} Onwards</span></li>

                                </ul>
                                <div class="tg-refundshare">
                                    {{-- <span class="tg-tourduration tg-location">Kandy,Negombo,galle</span></li>   --}}




                                </div>
                                {{-- <div class="tg-refundshare">
							<div class="tg-refund">
								<figure><img src="images/img-0.jpg" alt="image description"></figure>
								<div class="tg-refundinfo">
									<h3>100% refundable</h3>
									<div class="tg-description">
										<p>Cancel up to 12 days before your trip and get a full refund, including service fees.</p>
									</div>
								</div>
							</div>
							<ul class="tg-likeshare">
								<li class="tg-shareicon">
									<a href="javascript:void(0);"><i class="icon-share-button-outline"></i>share</a>
									<ul class="tg-share">
										<li><a href="javascript:void(0);"><i class="icon-twitter"></i></a></li>
										<li><a href="javascript:void(0);"><i class="icon-facebook"></i></a></li>
										<li><a href="javascript:void(0);"><i class="icon-pinterest"></i></a></li>
									</ul>
								</li>
								<li><a href="javascript:void(0);"><i class="icon-heart"></i>save to wish list</a></li>
								<li><a href="javascript:void(0);"><i class="icon-eye"></i>3520</a></li>
							</ul>
						</div> --}}
                            </div>
                            <div class="tg-sectionspace tg-haslayout">
                                <div class="tg-themetabs tg-bookingtabs">
                                    <ul class="tg-themetabnav" role="tablist">
                                        <li role="presentation" class="active">
                                            <a href="#america" aria-controls="america" role="tab" data-toggle="tab">
                                                <span>Overview</span>
                                            </a>
                                        </li>
                                        <li role="presentation">
                                            <a href="#australia" aria-controls="australia" role="tab" data-toggle="tab">
                                                <span>Itinerary</span>
                                            </a>
                                        </li>
                                        {{-- <li role="presentation">
									<a href="#italy" aria-controls="italy" role="tab" data-toggle="tab">
										<span>location</span>
									</a>
								</li> --}}
                                        {{-- <li role="presentation">
                                            <a href="#london" aria-controls="london" role="tab" data-toggle="tab">
                                                <span>Reviews</span>
                                            </a>
                                        </li> --}}
                                        {{-- <li role="presentation">
                                            <a href="#india" aria-controls="india" role="tab" data-toggle="tab">
                                                <span>Gallery</span>
                                            </a>
                                        </li> --}}
                                    </ul>
                                    <div class="tab-content tg-themetabcontent">
                                        <div role="tabpanel" class="tab-pane active tg-overviewtab" id="america">
                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <h2>About this Package</h2>
                                                    <div class="tg-description">
                                                        {!! $data->description !!}
                                                    </div>
                                                </div>
                                                {{-- <div class="tg-box">
                                                    <h2>Guest access</h2>
                                                    <div class="tg-description">
                                                        <p>Proin condimentum fermentum nunc. Etiam pharetra, erat sed
                                                            fermentum feugiat, velit mauris egestas quam.</p>
                                                        <p>Maecenas sed diam eget risus varius blandit sit amet non magna.
                                                            Vivamus sagittis lacus vel augue Sed non mauris vitae;erat
                                                            consequat auctor eu in elit. Class aptent taciti sociosqu ad
                                                            litora torquent per conubia nostra.</p>
                                                        <ul class="tg-liststyle">
                                                            <li><span>Ipsum Amet Mattis Pellentesque</span></li>
                                                            <li><span>Ultricies Vehicula Mollis Vestibulum Fringilla</span>
                                                            </li>
                                                            <li><span>Condimentum Sollicitudin Fusce Vestibulum
                                                                    Ultricies</span></li>
                                                            <li><span>Sollicitudin Consectetur Quam Ligula Vehicula</span>
                                                            </li>
                                                            <li><span>Cursus Pharetra Purus Porta Parturient</span></li>
                                                        </ul>
                                                    </div>
                                                </div> --}}
                                            </div>
                                            {{-- <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-amentities">
                                                    <h3>Package Inclusions</h3>
                                                    <div class="tg-content">
                                                        <ul class="tg-liststyle">
                                                            <li><span>Pets allowed</span></li>
                                                            <li><span>Internet</span></li>
                                                            <li><span>Gym</span></li>
                                                            <li><span>Hot tub</span></li>
                                                            <li><span>Doorman</span></li>
                                                            <li><span>Wheelchair accessible</span></li>
                                                            <li><span>Pool</span></li>
                                                        </ul>
                                                        <ul class="tg-liststyle">
                                                            <li><span>Kitchen</span></li>
                                                            <li><span>Suitable for events</span></li>
                                                            <li><span>Dryer</span></li>
                                                            <li><span>Family/kid friendly</span></li>
                                                            <li><span>Cable TV</span></li>
                                                            <li><span>Wireless Internet</span></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div> --}}
                                            <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-priceinclude">
                                                    <h3>Price Includes</h3>
                                                    <div class="tg-content">
                                                        {!! $data->includes !!}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- <div class="tg-bookingdetail tg-bookingdetailstyle">
                                                <div class="tg-box tg-amentities">
                                                    <h3>Tour Rules</h3>
                                                    <div class="tg-content">
                                                        <div class="tg-description">
                                                            <p>Maecenas sed diam eget risus varius blandit sit amet non
                                                                magna. Vivamus sagittis lacus vel augue Sed non mauris
                                                                vitae;erat consequat auctor eu in elit. Class aptent taciti
                                                                sociosqu ad litora torquent.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> --}}
                                        </div>
                                        <div role="tabpanel" class="tab-pane tg-itinerary" id="australia">
                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <div class="tg-accordion" role="tablist" aria-multiselectable="true">
                                                        @php
                                                            $halfCount = count($itinerary) / 2;
                                                            $firstHalf = $itinerary->slice(0, $halfCount);
                                                            $secondHalf = $itinerary->slice($halfCount);
                                                        @endphp

                                                        @foreach ($firstHalf as $item)
                                                            <div class="tg-panel day1">
                                                                <h4>{{ $item->day }}
                                                                    <span>{!! $item->title !!}</span>
                                                                </h4>
                                                                <div class="tg-panelcontent">
                                                                    <div class="tg-description">
                                                                        {!! $item->description !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tg-bookingdetail">
                                                <div class="tg-box">
                                                    <div id="tg-accordion" class="tg-accordion" role="tablist"
                                                        aria-multiselectable="true">
                                                        @foreach ($secondHalf as $item)
                                                            <div class="tg-panel day3">
                                                                <h4>{{ $item->day }} <span>{!! $item->title !!}</span></h4>
                                                                <div class="tg-panelcontent">
                                                                    <div class="tg-description">
                                                                        {!! $item->description !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- <div role="tabpanel" class="tab-pane tg-locationtab" id="italy">
                                            <div class="tg-box tg-location">
                                                <h3>The neighborhood</h3>
                                                <div class="tg-description">
                                                    <p>Curabitur blandit tempus porttitor. Lorem ipsum dolor sit amet,
                                                        consectetur adipiscing elit. Cras mattis consectetur purus sit amet
                                                        fermentum. Etiam porta sem malesuada magna mollis
                                                        euismod. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                                    </p>
                                                </div>
                                                <div id="tg-locationmap" class="tg-locationmap tg-map"></div>
                                            </div>
                                        </div> --}}
                                        {{-- <div role="tabpanel" class="tab-pane tg-reviewtab" id="london">
                                            <div class="tg-reviewsarea">
                                                <form class="tg-formtheme tg-formreviews">
                                                    <fieldset class="tg-filterby">
                                                        <div class="tg-durationrating">
                                                            <em>(3 Review)</em>
                                                            <span class="tg-stars"><span></span></span>
                                                        </div>
                                                        <span class="tg-select">
                                                            <select>
                                                                <option>Filter by</option>
                                                                <option>Rating</option>
                                                                <option>New</option>
                                                                <option>date</option>
                                                            </select>
                                                        </span>
                                                    </fieldset>
                                                    <fieldset class="tg-reviews">
                                                        <ul>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu.</p>
                                                                            <p>First, please don’t fall sick. However, if in
                                                                                case something does catchup with you, we
                                                                                will airlift you to hospital but your
                                                                                insurance will have to pay for this. Ulins
                                                                                aliquam massa nisl quis neque. Proin
                                                                                condimentum fermentum nunc. Etiam pharetra,
                                                                                erat sed fermentum feugiat, velit mauris
                                                                                egestas quam, ut liquam massa nisl quis
                                                                                neque.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>What a magical place, even better than I
                                                                                imagined! Teresa and Daniella were so
                                                                                helpful and awesome</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Very nice place</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="tg-review">
                                                                    <div class="tg-author">
                                                                        <figure class="tg-authorimg">
                                                                            <img src="images/img-01_1.jpg"
                                                                                alt="image description">
                                                                        </figure>
                                                                        <div class="tg-authorinfo">
                                                                            <h3>Katie</h3>
                                                                            <span>Family Vacation</span>
                                                                            <span class="tg-stars"><span></span></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tg-reviewcontent">
                                                                        <div class="tg-reviewhead">
                                                                            <span class="tg-tourduration">January 25,
                                                                                2017</span>
                                                                            <a class="tg-btnhelpfull" href="#"><i
                                                                                    class="icon-thumb-up"></i>Helpful</a>
                                                                        </div>
                                                                        <div class="tg-description">
                                                                            <p>Maecenas sed diam eget risus varius blandit
                                                                                sit amet non magna. Vivamus sagittis lacus
                                                                                vel augue Sed non mauris vitae;erat
                                                                                consequat auctor eu in elit. Class aptent
                                                                                taciti sociosqu ad litora torquent per
                                                                                conubia nostra, per inceptos himenaeos.
                                                                                Mauris in erat justo First, please don’t
                                                                                fall sick. However, if in case something
                                                                                does catchup.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </fieldset>
                                                    <fieldset class="tg-formleavereview">
                                                        <div class="tg-leavereviewhead">
                                                            <h2>Leave your Comment</h2>
                                                            <div class="tg-durationrating">
                                                                <h3>Your Rating</h3>
                                                                <span class="tg-stars"><span></span></span>
                                                            </div>
                                                        </div>
                                                        <div class="tg-reviewformarea">
                                                            <div class="form-group">
                                                                <input type="text" name="fullname"
                                                                    class="form-control" placeholder="Full Name">
                                                            </div>
                                                            <div class="form-group">
                                                                <input type="email" name="email" class="form-control"
                                                                    placeholder="Email Address">
                                                            </div>
                                                            <div class="form-group">
                                                                <textarea placeholder>Your Comment</textarea>
                                                            </div>
                                                            <div class="form-group">
                                                                <a class="tg-btn" href="#"><span>submit</span></a>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </form>
                                            </div>
                                        </div> --}}
                                        <div role="tabpanel" class="tab-pane tg-gallerytab" id="india">
                                            <div class="tg-gallery">
                                                <ul>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/6-Reasons-Sri-Lanka-Should-Be-On-Your-Travel-Radar-This-Year.jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/6-Reasons-Sri-Lanka-Should-Be-On-Your-Travel-Radar-This-Year.jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (1).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (1).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                    <li>
                                                        <figure>
                                                            <a href="{{ asset('images/i (3).jpg') }}"
                                                                data-rel="prettyPhoto[instagram]">
                                                                <img src="{{ asset('images/i (3).jpg') }}"
                                                                    alt="image decruoton">
                                                            </a>
                                                        </figure>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--************************************
                              Article Start
                            *************************************-->
        {{-- <div class="tg-sectionspace tg-haslayout tg-bglight">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead tg-sectionheadvtwo">
                            <div class="tg-sectiontitle">
                                <h2>Latest Articles</h2>
                            </div>
                            <div class="tg-description">
                                <p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam consectetuer</p>
                            </div>
                        </div>
                    </div>
                    <div class="tg-posts">
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-01_3.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-02_1.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-03_2.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <img src="images/img-04_1.jpg" alt="image description">
                                    <figcaption>
                                        <h3><a href="javascript:void(0);">Bungee Jumping Trip</a></h3>
                                        <time datetime="2017-06-08">Feb 22, 2017</time>
                                    </figcaption>
                                </figure>
                            </article>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}
        <!--************************************
                              Article End
                            *************************************-->
    </main>
    <!--************************************
                             Main End
                            *************************************-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css"></script>
    <script src=""></script>
    <script>
        $(document).ready(function() {

            $("#owl-demo").owlCarousel({
                navigation: true,
                items: 1,
                loop: true,

                nav: false,
                autoplay: true,
                animateOut: 'fadeOut',
                animateIn: 'fadeIn',
            });

        });
    </script>
@endsection
