@extends('partials.main')
@section('title')
    {{ 'Rent a Vehicle' }}
@endsection
@section('content')
    <style>
        img.advance-btn {
            height: 200px !important;
            object-fit: cover;
        }

        .tg-description span {
            color: #ff7550;
        }
    </style>
    <!--************************************
                                                            Inner Banner Start
                                                          *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/sea-7145940_1280.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>Rent a Vehicle</h1>
                        <h2>Hire Your Private Tour Car and Chauffeur with us </h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">Rent a Vehicle</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                                                            Inner Banner End
                                                          *************************************-->
    <!--************************************
                                                            Main Start
                                                          *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout">
        <div class="container">
            <div class="row">



                <section>
                    <div id="car" style="padding-top: 50px" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div id="tg-content" class="tg-content">
                            <div class="tg-listing tg-listingvtwo">
                                <div class="tg-sectiontitle">
                                    <h2> Rent a car with Driver</h2>
                                </div>
                                <div class="clearfix">

                                    <div id="tg-populartoursslider-car"
                                        class="tg-populartoursslider tg-populartours tg-populartoursvtwo owl-carousel">

                                        @foreach ($cars as $car)
                                            <div class="item tg-populartour">
                                                <figure>
                                                    <a href="/rentcar-detail/{{ $car->slug }}">
                                                        <img src="{{ asset('thumbnails/' . $car->image) }}"
                                                            alt="image destinations" class="advance-btn"></a>
                                                    <span
                                                        class="tg-descount">{{ $car->discount ? $car->discount . '% Off' : '' }}</span>

                                                </figure>
                                                <div class="tg-populartourcontent">
                                                    <div class="tg-populartourtitle">
                                                        <h3><a
                                                                href="/rentcar-detail/{{ $car->slug }}">{{ $car->name }}</a>
                                                        </h3>
                                                    </div>
                                                    <div class="tg-description">
                                                        <p>{{ $car->pax }}</p>
                                                    </div>
                                                    <div class="tg-populartourfoot">
                                                        <form action="/quotation" method="post">
                                                            @csrf
                                                            <input name="type" type="hidden" value="vehi">
                                                            <input name="name" type="hidden"
                                                                value="{{ $car->name }}">
                                                            <button class="tg-btnaddtocart" type="submit"> <i
                                                                    class="icon-icons240"></i>
                                                                <span>Request Quote </span></button>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach


                                    </div>
                                </div>


                            </div>
                        </div>
                </section>

                <section>
                    <div id="van" style="padding-top: 50px" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div id="tg-content" class="tg-content">
                            <div class="tg-listing tg-listingvtwo">
                                <div class="tg-sectiontitle">
                                    <h2> Rent a Van with Driver</h2>
                                </div>
                                <div class="clearfix">

                                    <div id="tg-populartoursslider-van"
                                        class="tg-populartoursslider tg-populartours tg-populartoursvtwo owl-carousel">

                                        @foreach ($vans as $van)
                                            <div class="item tg-populartour">
                                                <figure><a href="/rentcar-detail/{{ $van->slug }}">
                                                        <img src="{{ asset('thumbnails/' . $van->image) }}"
                                                            alt="image destinations" class="advance-btn"></a>

                                                    <span
                                                        class="tg-descount">{{ $van->discount ? $van->discount . '% Off' : '' }}</span>
                                                </figure>
                                                <div class="tg-populartourcontent">
                                                    <div class="tg-populartourtitle">
                                                        <h3><a
                                                                href="/rentcar-detail/{{ $van->slug }}">{{ $van->name }}</a>
                                                        </h3>
                                                    </div>
                                                    <div class="tg-description">
                                                        <p>{{ $van->pax }}</p>
                                                    </div>
                                                    <div class="tg-populartourfoot">
                                                        <form action="/quotation" method="post">
                                                            @csrf
                                                            <input name="type" type="hidden" value="vehi">
                                                            <input name="name" type="hidden"
                                                                value="{{ $van->name }}">
                                                            <button class="tg-btnaddtocart" type="submit"> <i
                                                                    class="icon-icons240"></i>
                                                                <span>Request Quote </span></button>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach



                                    </div>
                                </div>


                            </div>
                        </div>
                </section>

                <section>
                    <div id="luxury" style="padding-top: 50px" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div id="tg-content" class="tg-content">
                            <div class="tg-listing tg-listingvtwo">
                                <div class="tg-sectiontitle">
                                    <h2> Rent a Luxury Car with Driver</h2>
                                </div>
                                <div class="clearfix">

                                    <div id="tg-populartoursslider-lx"
                                        class="tg-populartoursslider tg-populartours tg-populartoursvtwo owl-carousel">

                                        @foreach ($luxury as $luxury)
                                            <div class="item tg-populartour">
                                                <figure><a href="/rentcar-detail/{{ $luxury->slug }}">
                                                        <img src="{{ asset('thumbnails/' . $luxury->image) }}"
                                                            alt="image destinations" class="advance-btn"></a>
                                                    <span
                                                        class="tg-descount">{{ $luxury->discount ? $luxury->discount . '% Off' : '' }}</span>
                                                </figure>
                                                <div class="tg-populartourcontent">
                                                    <div class="tg-populartourtitle">
                                                        <h3><a href="/rentcar-detail/{{ $luxury->slug }}">
                                                                {{ $luxury->name }}</a>
                                                        </h3>
                                                    </div>
                                                    <div class="tg-description">
                                                        <p> {{ $luxury->pax }}</p>
                                                    </div>
                                                    <div class="tg-populartourfoot">
                                                        <form action="/quotation" method="post">
                                                            @csrf
                                                            <input name="type" type="hidden" value="vehi">
                                                            <input name="name" type="hidden"
                                                                value=" {{ $luxury->name }}">
                                                            <button class="tg-btnaddtocart" type="submit"> <i
                                                                    class="icon-icons240"></i>
                                                                <span>Request Quote </span></button>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach


                                    </div>
                                </div>


                            </div>
                        </div>
                </section>

                <section>
                    <div id="bus" style="padding-top: 50px" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div id="tg-content" class="tg-content">
                            <div class="tg-listing tg-listingvtwo">
                                <div class="tg-sectiontitle">
                                    <h2> Rent a Bus with Driver</h2>
                                </div>
                                <div class="clearfix">

                                    <div id="tg-populartoursslider-bus"
                                        class="tg-populartoursslider tg-populartours tg-populartoursvtwo owl-carousel">

                                        @foreach ($bus as $bus)
                                            <div class="item tg-populartour">
                                                <figure><a href="/rentcar-detail/{{ $bus->slug }}">
                                                        <img src="{{ asset('thumbnails/' . $bus->image) }}"
                                                            alt="image destinations" class="advance-btn"></a>
                                                    <span
                                                        class="tg-descount">{{ $bus->discount ? $bus->discount . '% Off' : '' }}</span>
                                                </figure>
                                                <div class="tg-populartourcontent">
                                                    <div class="tg-populartourtitle">
                                                        <h3><a href="/rentcar-detail/{{ $bus->slug }}">
                                                                {{ $bus->name }}</a>
                                                        </h3>
                                                    </div>
                                                    <div class="tg-description">
                                                        <p> {{ $bus->pax }}</p>
                                                    </div>
                                                    <div class="tg-populartourfoot">
                                                        <form action="/quotation" method="post">
                                                            @csrf
                                                            <input name="type" type="hidden" value="vehi">
                                                            <input name="name" type="hidden"
                                                                value=" {{ $bus->name }}">
                                                            <button class="tg-btnaddtocart" type="submit"> <i
                                                                    class="icon-icons240"></i>
                                                                <span>Request Quote </span></button>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach


                                    </div>
                                </div>


                            </div>
                        </div>
                </section>
            </div>
        </div>

    </main>
    <!--************************************
                                                            Main End
                                                          *************************************-->
@endsection
