@extends('partials.main')
@section('title')
    {{ 'Payment' }}
@endsection
@section('content')
    <style>
        .tg-description span {
            color: #ff7550;
        }

        .lds-dual-ring {
            display: inline-block;
            width: 80px;
            height: 80px;
        }

        .lds-dual-ring:after {
            content: " ";
            display: block;
            width: 64px;
            height: 64px;
            margin: 8px;
            border-radius: 50%;
            border: 6px solid #ccc;
            border-color: #ccc transparent #ccc transparent;
            animation: lds-dual-ring 1.2s linear infinite;
        }

        @keyframes lds-dual-ring {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }

        }

        .tg-totalpayment button.tg-btn span {
            color: #000;
            float: left;
            font-weight: 500;
        }

        button.tg-btn:hover::after {
            background: #fee133;
        }
    </style>

    <!--************************************
                                Inner Banner Start
                              *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../thumbnails/{{ $banner->image }}">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>{{ $banner->heading }}</h1>
                        <h2>{{ $banner->subheading }}</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">{{ $banner->heading }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                                Inner Banner End
                              *************************************-->
    <!--************************************
                                Main Start
                              *************************************-->
    <main id="tg-main" class="tg-main tg-haslayout">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div id="" class="tg-content">
                            <div class="tg-billingdetail">
                                <form method="POST" action="/paymentRedirect" class="tg-formtheme tg-formbillingdetail">
                                    @csrf
                                    <fieldset class="tg-paymentarea">
                                        <div id="tg-accordion" class="tg-accordion" role="tablist"
                                            aria-multiselectable="true">
                                            <div class="tg-panel">
                                                <h4 class="tg-radio active ">
                                                    <input type="radio" id="bank-transfer" name="paymenttype" checked>
                                                    <label for="bank-transfer">Direct Bank Transfer</label>
                                                </h4>
                                                <div class="tg-panelcontent" style="display: block;">
                                                    <div class="tg-description">
                                                        <p>Account Name : LANKA GETAWAYS<br><br>
                                                            Account Number :111000074687<br><br>

                                                            Bank Name :National Development Bank PLC (NDB BANK)<br><br>
                                                            Branch : Kochchikade<br><br>
                                                            SWIFT Code: NDBSLKLX<br><br>
                                                            Bank Address: No. 40, Nawam Mawatha, Colombo 02 (1825) Sri
                                                            Lanka.
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tg-panel">
                                                <h4 class="tg-radio ">
                                                    <input type="radio" id="creditcard" name="paymenttype">
                                                    <label for="creditcard"> Card Payments </label>
                                                    <img src="images/visastrip.jpg" alt="image description">
                                                </h4>
                                                <div class="tg-panelcontent" style="display: none;">
                                                    <div class="tg-description">
                                                        <p> Lorem ipsum dolor sit amet consectetur adipisicing elit.
                                                            Veritatis, voluptate magnam. Qui quod necessitatibus quia
                                                            magnam. Molestias ipsa mollitia voluptates non consequuntur quo,
                                                            earum, quasi, accusantium adipisci nam nisi. Molestiae.</p>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </fieldset>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        $('#usdVal').on('keyup', function() {

            var usdVal = $('#usdVal').val();
            $('.lds-dual-ring').show();

            $.get('https://openexchangerates.org/api/latest.json', {
                app_id: '811cf811c0224b1baac23040d89c64a3'
            }, function(data) {

                var lkr = data.rates.LKR;
                var total = (lkr * usdVal).toFixed(2);

                $('#txtPrice').val(total);

                $('#lkrVal').text("Amount in LKR: " + total);
                $('.lds-dual-ring').hide();
            });

        });
    </script>
@endsection
