@extends('partials.main')
@section('title')
    {{ 'Hotel Reservations' }}
@endsection
@section('content')
    <style>
        .fa-star {
            color: #ff7550;
        }

        .tg-description span {
            color: #ff7550;
        }

        .tg-populartourvtwo .tg-populartourcontent .tg-description p {
            margin: 0 0 30px;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 5;
            -webkit-box-orient: vertical;
        }

        .tg-populartourfoot {
            width: 100%;
            float: left;
            padding: 55px 0 0;
            border-top: 1px solid #e6e6e6;
        }

        .hotel-img {
            width: 410px !important;
            height: 273px !important;
            object-fit: cover;
        }
    </style>



    <!--************************************
                Inner Banner Start
              *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../thumbnails/{{ $banner->image }}">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>{{ $banner->heading }}</h1>
                        <h2>{{ $banner->subheading }}</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">{{ $banner->heading }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                Inner Banner End
              *************************************-->
    <!--************************************
                Main Start
              *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout tg-bglight">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">
                        <div class="tg-listing tg-listingvthree">
                            <div class="tg-sectiontitle">
                                <h2>Hotel Reservations</h2>
                            </div>

                            @foreach ($hotels as $hotel)
                                <div class="tg-populartour tg-populartourvtwo">
                                    <figure>
                                        <a href="/hotel-reservations">
                                            <img class="hotel-img" src="{{ asset('thumbnails/' . $hotel->thumbnail) }}">
                                            {{-- <img  src="images/134394306.jpg" alt="image destinations"> --}}
                                        </a>
                                    </figure>
                                    <div class="tg-populartourcontent">
                                        <div class="tg-populartourtitle">
                                            <h3><a href="/hotel-reservations">{{ $hotel->title }}</a></h3>
                                        </div>
                                        <div class="tg-description">
                                            <p>{{ $hotel->description }}</p>
                                            <h6>{{ $hotel->rooms }}</h6>
                                        </div>
                                        <div class="tg-populartourfoot">
                                            <div class="tg-durationrating">
                                                {{-- <span class="tg-tourduration">7 Days</span> --}}




                                            </div>

                                        </div>
                                        <div class="tg-priceavailability">
                                            <div class="tg-availhead">
                                                <time>Location : {{ $hotel->location }}</time>
                                            </div>
                                            <div class="tg-pricearea">
                                                <span>Rating</span>
                                                @for ($i = 0; $i < $hotel->stars; $i++)
                                                    <i class="fas fa-star"></i>
                                                @endfor
                                                {{-- <span>From</span>
                <h4>${{$hotel->price}}</h4> --}}
                                            </div>
                                            <form action="/booking" method="post">
                                                @csrf
                                                <input name="hotel" value="{{ $hotel->title }}" type="hidden">
                                                <button class="tg-btn" type="submit">Check availability</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach



                            {{-- <nav class="tg-pagination">
                                <ul>
                                    <li class="tg-active"><a href="javascript:void(0);">1</a></li>
                                    <li><a href="javascript:void(0);">2</a></li>
                                    <li><a href="javascript:void(0);">3</a></li>
                                    <li><a href="javascript:void(0);">4</a></li>
                                    <li class="tg-nextpage"><a href="javascript:void(0);"><i
                                                class="fa fa-angle-right"></i></a></li>
                                </ul>
                            </nav> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--************************************
                Main End
              *************************************-->
@endsection
