@extends('client.layout.main')
@section('title')
    {{ 'user' }}
@endsection
@section('content')
    <style>
        form {
            background-color: #f9f9f9;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }


        .text-center {
            text-align: center;
        }


        h3 {
            color: #333;
        }


        p {
            font-size: 14px;
            color: #555;
        }


        h5 {
            color: #333;
            font-weight: bold;
        }


        button {
            background-color: #007BFF;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background-color: #0056b3;
        }
    </style>
    <div style="padding-top: 70px; padding-left: 10px; " class="height-100 bg-light ">
        <section id="stats-subtitle">
            <div class="row">
                <div class="col-12 mt-3 mb-1">
                    <h4 class="text-uppercase">Statistics</h4>
                    <p>Exploring Our Tour History</p>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-6 col-md-12">
                    <div class="card overflow-hidden">
                        <div class="card-content">
                            <div class="card-body cleartfix">
                                <div class="media align-items-stretch">
                                    <div class="align-self-center">
                                        <i class="fas fa-coins primary font-large mr-2"></i>

                                    </div>
                                    <div class="media-body">
                                        <h4>Total Points</h4>
                                        <span> Total Earn points</span>
                                    </div>
                                    <div class="align-self-center">
                                        <h1>{{auth()->guard('client')->user()->points ?? 0 }}</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-6 col-md-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body cleartfix">
                                <div class="media align-items-stretch">
                                    <div class="align-self-center">
                                        <i class="fas fa-suitcase-rolling primary font-large mr-2"></i>

                                    </div>
                                    <div class="media-body">
                                        <h4>Total Tours</h4>
                                        <span>Total Tours in Partnership with Us</span>
                                    </div>
                                    <div class="align-self-center">
                                        <h1>{{ $tours->count() }}</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div style="margin-top:10px;" class="col-xl-4">
                <form action="/point-claim" method="POST">
                    @csrf
                    <div class="text-center">
                        <h3>Claim My points</h3>
                    </div>

                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur nam doloribus quidem provident
                        assumenda quaerat, dolor saepe asperiores rem impedit a dignissimos quisquam corporis accusamus
                        incidunt suscipit neque, consectetur quis.</p>
                    <input type="hidden" name="point" value="{{ auth()->guard('client')->user()->points ?? 0 }}">
                    <input type="hidden" name="client" value="{{ auth()->guard('client')->user()->id }}">
                    <h5>Total points:{{ auth()->guard('client')->user()->points  ?? 0}}</h5>
                    <button type="submit">Claim</button>
                </form>
            </div>

        </section>
    </div>
@endsection
