@extends('partials.main')
@section('title')
    {{ 'Blog' }}
@endsection
@section('content')
    <style>
        .fa-star {
            color: #ff7550;
        }

        .tg-description span {
            color: #ff7550;
        }

        .tg-populartourvtwo .tg-populartourcontent .tg-description p {
            margin: 0 0 30px;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 5;
            -webkit-box-orient: vertical;

        }

        .tg-populartourfoot {
            width: 100%;
            float: left;
            padding: 5px 0 0;
            border-top: 1px solid #e6e6e6;
        }

        .hotel-img {
            width: 410px !important;
            height: 273px !important;
            object-fit: cover;
        }

        /* card-dwon */
        .card {

            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        img.card-img-top {
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }

        .blog-cardbody {
            padding: 10px;
        }

        .card.card-dwon {
            margin-bottom: 20px;
        }

        .list-blog {
            margin-bottom: 20px;
        }


        .card-block {
            padding-bottom: 0px;
            padding-right: 15px;
            padding-left: 15px;
        }

        img.img-fluid.imt {
            height: 142px;
            object-fit: cover;
            border-bottom-left-radius: 5px;
            border-top-left-radius: 5px;
            width: 100%;
        }

        p.card-text {
            margin: 0 0 0px !important;
        }

        .card-body.blog-cardbody {
            min-height: 200px;
            max-height: 200px;
        }

        a,
        a:hover,
        a:hover,
        a:focus,
        a:active {
            color: #5a5b5d;
        }

        li.des {
            padding: 30px;
        }

        .owl-carousel .owl-dot span {
            width: 10px;
            height: 10px;
            display: block;
            border-radius: 50%;
            background: rgba(239, 53, 2, 0.5);
        }

        .owl-carousel .owl-dot:hover span,
        .owl-carousel .owl-dot.active span {
            width: 12px;
            height: 12px;
            background: rgb(241, 100, 100);
        }

        .pick-btn {
            z-index: 1;
            color: #fff;
            height: 60px;
            padding: 0 50px;
            overflow: hidden;
            background: #ff7550;
            position: relative;
            text-align: center;
            display: inline-block;
            vertical-align: middle;
            text-transform: uppercase;
            font: 400 12px/60px 'Montserrat', Arial, Helvetica, sans-serif;
        }

        .pick-btn:hover {
            color: rgb(11, 11, 11);
            background: #fee133 !important;
        }

        li.des:hover {
            border: black;
            border: 2px solid #000;
            padding: 10px 20px;
            text-decoration: none;
            display: inline-block;
        }

        .owl-carousel .owl-item img {
            width: 100%;
            height: 350px;
            object-fit: cover;
            border-radius: 22px;
        }

        .tg-guidecontenthead {

            padding: 0 0px 10px 0 !important;
        }
    </style>



    <!--************************************
                                                Inner Banner Start
                                              *************************************-->
                                              <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
                                              data-image-src="../thumbnails/{{ $banner->image }}">
                                              <div class="tg-sectionspace tg-haslayout">
                                                  <div class="container">
                                                      <div class="row">
                                                          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                              <h1>{{ $banner->heading }}</h1>
                                                              <h2>{{ $banner->subheading }}</h2>
                                                              <ol class="tg-breadcrumb">
                                                                  <li><a href="javascript:void(0);">Home</a></li>
                                                                  <li class="tg-active">{{ $banner->heading }}</li>
                                                              </ol>
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </section>
    <main id="tg-main" class="tg-main tg-haslayout">
        <!--************************************
                                                    wellcome Start
                                            *************************************-->
        <section class="tg-sectionspace tg-haslayout tg-bglight">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead">
                            <div class="tg-sectiontitle">
                                <h2>   {{$plan->name}} 
                                </h2>
                            </div>

                        </div>

                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            {!!$plan->description!!} 

                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div id="tg-plannig" class="tg-guidesslider tg-guides owl-carousel">

                                @foreach ($planning as $post)
                                    <div class="item tg-guide">
                                        <figure><a href="javascript:void(0);"><img
                                                    src="{{ asset('thumbnails/' . $post->thumbnail) }}"
                                                    alt="image destination"></a></figure>
                                        <div class="tg-guidecontent">
                                            <div class="tg-guidecontenthead">
                                                <h3><a href="/blog-detail/{{ $post->slug }}">{{ $post->title }}</a></h3>


                                            </div>

                                        </div>
                                    </div>
                                @endforeach


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--************************************
                                                    Our Guides End
                                            *************************************-->
        <!--************************************
                                                    Call To Action Start
                                            *************************************-->

        <!--************************************
                                                    Call To Action End
                                            *************************************-->
        <section class="tg-sectionspace tg-haslayout tg-bglight">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead">
                            <div class="tg-sectiontitle">
                                <h2> {!!$sty->name!!} </h2>
                            </div>

                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div id="tg-blogslider" class="tg-guidesslider tg-guides owl-carousel">
                                @foreach ($styles as $post)
                                    <div class="item tg-guide">
                                        <figure><a href="/blog-detail/{{ $post->slug }}"><img
                                                    src="{{ asset('thumbnails/' . $post->thumbnail) }}"
                                                    alt="image destination"></a></figure>
                                        <div class="tg-guidecontent">
                                            <div class="tg-guidecontenthead">
                                                <h3><a href="/blog-detail/{{ $post->slug }}">{{ $post->title }}</a></h3>


                                            </div>

                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">

                            {!!$sty->description!!} 

                        </div>
                      

                    </div>
                </div>
            </div>
        </section>
        <!--************************************
                                                    About Us Start
                                            *************************************-->
        <section class="tg-sectionspace tg-haslayout tg-bglight">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead">
                            <div class="tg-sectiontitle">
                                <h2>{{$des->name}} </h2>
                            </div>

                        </div>

                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">

{!!$des->description!!}

                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div id="tg-des" class="tg-guidesslider tg-guides owl-carousel">

                                @foreach ($destination as $des)
                                    <div class="item tg-guide">
                                        <figure><a href="javascript:void(0);"><img
                                                    src="{{ asset('thumbnails/' . $des->thumbnail) }}"
                                                    alt="image destination"></a></figure>
                                        <div class="tg-guidecontent">
                                            <div class="tg-guidecontenthead">
                                                <h3><a href="/blog-detail/{{ $des->slug }}">{{ $des->title }}</a>
                                                </h3>


                                            </div>

                                        </div>
                                    </div>
                                @endforeach


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="tg-sectionspace tg-zerotoppadding tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-sectionhead tg-sectionheadvtwo">
                            <div class="tg-sectiontitle">
                                <h2>{{$f1->value}}</h2>
                            </div>
                            <div class="tg-description">
                                <p>{{$f2->value}}</p>
                            </div>
                        </div>
                    </div>
                    <div class="tg-posts">
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <a href="/rent-vehicle">
                                        <img src="{{ asset('thumbnails/'.$f3->value) }}"
                                            alt="image description">
                                        <div class="tg-hover">
                                            <h3> {{$f3->part}}</h3>

                                        </div>
                                    </a>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <a href="/rent-vehicle">
                                        <img src="{{ asset('thumbnails/'.$f4->value) }}"
                                            alt="image description">
                                        <div class="tg-hover">
                                            <h3> {{$f4->part}}</h3>

                                        </div>
                                    </a>
                                </figure>
                                
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <a href="/rent-vehicle">
                                        <img src="{{ asset('thumbnails/'.$f5->value) }}"
                                            alt="image description">
                                        <div class="tg-hover">
                                            <h3> {{$f5->part}}</h3>

                                        </div>
                                    </a>
                                </figure>
                            </article>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <article class="tg-post">
                                <figure>
                                    <a href="/rent-vehicle">
                                        <img src="{{ asset('thumbnails/'.$f6->value) }}"
                                            alt="image description">
                                        <div class="tg-hover">
                                            <h3> {{$f6->part}}</h3>

                                        </div>
                                    </a>
                                </figure>
                            </article>
                        </div>
                    </div>
                </div>
            </div>
        </section>


    </main>
@endsection
