@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage melani's map</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Melani's map</a>
                                    </li>
                                    <li class="breadcrumb-item active">Melani's map Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <h4>Melani's Map Description</h4>
                                <form action="/portal-description" method="post">
                                    @csrf
                                    <textarea name="description" class="summernote" id="">
                                       {!! $portal->description !!}
                                    </textarea>
                                    <br> <button class="btn btn-success " type="submit">Update</button>
                                </form>


                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title"> Add Video </h4>

                                <form action="/add-youtubevideo" enctype="multipart/form-data" method="post">
                                    @csrf

                                    <input type="hidden" name="id" value="1">
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label"> Youtube embed
                                            link</label>
                                        <div class="col-sm-10">
                                            <input type="text"class="form-control" name="video">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label"> Title </label>
                                        <div class="col-sm-10">
                                            <input type="text"class="form-control" name="title">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label"> Description
                                        </label>
                                        <div class="col-sm-10">
                                            <textarea name="detail" id="" class="form-control"></textarea>
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Melani's map video list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Id</th>
                                            <th>Video</th>
                                            <th>Title</th>
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data as $data)
                                            <tr>
                                                <td>{{ $data->id }}</td>
                                                <td> <iframe src="{{ $data->link }}"></iframe></td>
                                                <td>{{ $data->title }}</td>

                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('edit-youtubevideo', $data->id) }}"
                                                        role="button">Edit</a>
                                                    <a class="btn btn-danger delete"
                                                        href="{{ route('delete-youtubevideo', $data->id) }}"
                                                        role="button">Delete</a>
                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
    @endsection
