@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Tour itinerary list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Id</th>

                                            <th>Client</th>
                                            <th>Email</th>
                                            <th>Sub Total</th>

                                            <th>Due Payment</th>
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($datas as $data)
                                            <tr>
                                                <td>{{ $data->invoice }}</td>
                                                <td>{{ $data->name }}</td>
                                                <td>{{ $data->email }}</td>
                                                <td>{{ $data->subtotal }}</td>
                                                <td>{{ $data->total_due }}</td>
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('edit-itinerary', $data->id) }}" role="button">Edit
                                                        Itinerary</a>
                                                    @if ($data->total_due != 0)
                                                        <a class="btn btn-warning edit" href=""
                                                            onclick="confirmPayment()" role="button">Full
                                                            payment</a>
                                                        <script>
                                                            function confirmPayment() {
                                                                if (confirm("Are you sure you want to make a full payment?")) {

                                                                    window.location.href = "{{ route('full-payment', ['id' => $data->id]) }}";
                                                                }
                                                                event.preventDefault();
                                                            }
                                                        </script>
                                                    @endif
                                                    @if ($data->status == '0')
                                                        <a class="btn btn-success edit"
                                                            href="{{ route('driver-itinerary', $data->id) }}"
                                                            role="button">Select Driver</a>
                                                    @elseif ($data->status == '1')
                                                        <a class="btn btn-success edit"
                                                            href="{{ route('complete', $data->id) }}"
                                                            role="button">Complete</a>
                                                    @endif

                                                    <a class="btn btn-danger "
                                                        href="{{ route('delete-touritinerary', $data->id) }}"
                                                        onclick="return confirm('Are you sure you want to delete this client?')"
                                                        role="button"> Delete tour</a>

                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>
                                {!! $datas->links() !!}
                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
