@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <style>
        .newhotel {
            display: none;
        }

        <style>.select2-container--default .select2-results__option--selected {
            background-color: #ccc;
            color: #000;
        }

        .select2-container--default li {
            color: black;
        }
    </style>
    </style>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session('success') }}
                    </div>
                @endif



                @if (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session('error') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <ul class="list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/tour-quotation" id="myForm" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" readonly type="text" value="{{ $data->name }}"
                                                name="name" required>
                                            <input class="form-control" readonly type="hidden" value="{{ $data->id }}"
                                                name="clientid" required>

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="email" value="{{ $data->email }}"
                                                name="email" required>

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label"> Package Type</label>
                                        <div class="col-sm-10">

                                            <select class="form-control" name="packagetype" id="">
                                                <option value="t-package">Tour Package</option>
                                                <option value="car-driver">Car And Driver</option>


                                            </select>

                                        </div>
                                    </div>
                                    <div class="form-group car-driver ">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Duration </label>
                                        <div class="col-sm-5">
                                            <label for="example-text-input" class="col-sm-4 col-form-label">Start Date
                                            </label>
                                            <input class="form-control" type="date" value="" name="from">
                                        </div>
                                        <div class="col-sm-5">
                                            <label for="example-text-input" class="col-sm-4 col-form-label">
                                                End Date </label>
                                            <input class="form-control" type="date" value="" name="to">
                                        </div>


                                    </div>
                                    <h4 class="mt-0 header-title"> </h4>
                                    <div class="t-package">
                                   <div class="dynamic-table table-responsive">
                                            <table class="table table-bordered responsive" id="dynamic-table">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Location</th>
                                                        <th>Activities</th>
                                                        <th>Special Note</th>
                                                        <th>Hotel</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            Date <input class="form-control" type="date" name="date[0]">
                                                            <input type="hidden" name="day[0]" value="1">
                                                        </td>
                                                        <td>
                                                            Destination
                                                            <select class="form-control select2 destination"
                                                                name="destination[0]">
                                                                <option value="">Select Destination</option>
                                                                @foreach ($destinations as $des)
                                                                    <option value="{{ $des->id }}">{{ $des->title }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <div class="activity-list"></div>
                                                            <!-- Checkbox list will be appended here -->
                                                        </td>
                                                        <td>
                                                            <textarea class="form-control" name="note[0]" row="20" id=""></textarea>
                                                            <!-- <input class="form-control" type="text" name="hotel[0]"> -->
                                                        </td>
                                                        <td>
                                                            <input class="form-control" type="text" name="hotel[0]"
                                                                placeholder="Hotel Name">
                                                            <br>
                                                            <select class="form-control mt-2" name="basis[0]">
                                                                <option value="">Select Basis</option>
                                                                <option value="Bed & Breakfast Basis">Bed & Breakfast Basis
                                                                </option>
                                                                <option value="Half Board Basis (Breakfast & Dinner)">Half
                                                                    Board Basis (Breakfast & Dinner)</option>
                                                                <option value="Full Board Basis (All 3 Meals)">Full Board
                                                                    Basis (All 3 Meals)</option>
                                                                <option value="Breakfast + Complimentary Dinner">Breakfast
                                                                    + Complimentary Dinner</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-success add-row">Add
                                                                Row</button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Subject</label>
                                        <div class="col-sm-10">
                                            <select class="form-control" name="detail" id="detail">
                                                <option value="Your Customized Tour Quotation - Car"> Your
                                                    Customized Tour Quotation - Car</option>
                                                <option value="Your Customized Tour Quotation - Van">Your Customized Tour
                                                    Quotation - Van</option>
                                                <option value="Your Customized Tour Quotation - Van (7 Pax & Above)">Your
                                                    Customized Tour Quotation - Van (7 Pax & Above)</option>
                                                <option value="Your Customized Tour Quotation - Bus">Your Customized Tour
                                                    Quotation - Bus</option>
                                                <option value="Your Tailored Day Excursion Quote Inside - Car">Your
                                                    Tailored Day Excursion Quote Inside - Car</option>
                                                <option value="Your Tailored Day Excursion Quote Inside - Van">Your
                                                    Tailored Day Excursion Quote Inside - Van</option>
                                                <option value="Your Airport Transfer Quote">Your Airport Transfer Quote
                                                </option>
                                            </select>

                                        </div>
                                    </div>
                                         <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Pre Payment Amount</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" required type="text" placeholder=" "
                                                name="pre_payment">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Payament Link</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" required type="text" placeholder=" "
                                                name="payment_link">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label"> Vehicle</label>
                                        <div class="col-sm-10">

                                            <select class="form-control" name="vehicle" id="">
                                                <option value="Car">Car</option>
                                                <option value="Van">Van</option>
                                                <option value="Van (7 Pax & Above)"> Van (7 Pax & Above)</option>
                                                <option value="Bus">Bus</option>
                                            </select>

                                        </div>
                                    </div>


                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Luxury Cost</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" required type="text" placeholder=" "
                                                name="luxury_cost">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Economy Cost</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" required type="text" placeholder=" "
                                                name="economy_cost">
                                        </div>
                                    </div>
                                    <!-- <div class="form-group">
                                                                                                                                        <label class="col-sm-2 col-form-label">Pre Paid</label>
                                                                                                                                        <div class="col-sm-10">
                                                                                                                                            <input class="form-control" required type="number" step="any"
                                                                                                                                                placeholder=" " name="prepaid">
                                                                                                                                        </div>
                                                                                                                                    </div>
                                                                                                                                    <table class="table table-bordered responsive" id="dynamic-invoice">
                                                                                                                                        <thead>
                                                                                                                                            <tr>
                                                                                                                                                <th>Invoice</th>
                                                                                                                                                <th>Amount</th>
                                                                                                                                                <th>Action</th>

                                                                                                                                            </tr>
                                                                                                                                        </thead>
                                                                                                                                        <tbody>
                                                                                                                                            <tr>
                                                                                                                                                <td><input type="text" class="form-control " required
                                                                                                                                                        name="invoice[0]"></td>
                                                                                                                                                <td><input type="number" step="any" class="form-control " required
                                                                                                                                                        name="amount[0]"></td>
                                                                                                                                                <td> <button class="btn btn-warning" id="add-invoice-row">Add Row</button>
                                                                                                                                                </td>

                                                                                                                                            </tr>
                                                                                                                                        </tbody>
                                                                                                                                    </table> -->

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" id="submitBtn"
                                                class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <a href="{{ url()->previous() }}" type="reset"
                                                class="btn btn-secondary waves-effect m-l-5">
                                                Back
                                            </a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
            </div>
            <!-- container-fluid -->
        </div>
        <!-- content -->
    </div>
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->

    <script>
        $(document).ready(function() {
            // Default: Show t-package and hide car-driver
            $('.t-package').show();
            $('.car-driver').hide();

            // On change of packagetype
            $('select[name="packagetype"]').on('change', function() {
                var selectedType = $(this).val();

                if (selectedType === 't-package') {
                    $('.t-package').show();
                    $('.car-driver').hide();
                } else if (selectedType === 'car-driver') {
                    $('.car-driver').show();
                    $('.t-package').hide();
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            let rowIndex = 1;

            // Initialize Select2
            $(".select2").select2();

            // Function to fetch activities based on the selected destination
            function fetchActivities(destinationId, activityDiv, rowIdx) {
                if (destinationId) {
                    $.ajax({
                        url: '/get-activities', // Laravel route for fetching activities
                        type: 'GET',
                        data: {
                            destination_id: destinationId
                        },
                        success: function(response) {
                            let activityCheckboxes = "";
                            response.activities.forEach(activity => {
                                activityCheckboxes += `
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="activities[${rowIdx}][]" value="${activity.title}" id="activity-${rowIdx}-${activity.id}">
                                <label class="form-check-label" for="activity-${rowIdx}-${activity.id}">
                                    ${activity.title}
                                </label>
                            </div>`;
                            });
                            $(activityDiv).html(activityCheckboxes);
                        },
                        error: function() {
                            $(activityDiv).html(
                                "<p class='text-danger'>Error fetching activities.</p>");
                        }
                    });
                } else {
                    $(activityDiv).html("");
                }
            }

            // Handle destination change event
            $(document).on("change", ".destination", function() {
                let destinationId = $(this).val();
                let rowIdx = $(this).closest("tr").index(); // Get the row index
                let activityDiv = $(this).closest("tr").find(".activity-list");
                fetchActivities(destinationId, activityDiv, rowIdx);
            });

            // Add new row dynamically
               $(document).on("click", ".add-row", function() {
                let newRow = `<tr>
            <td>
                Date <input class="form-control" type="date" required name="date[${rowIndex}]">
                <input type="hidden" name="day[${rowIndex}]" value="${rowIndex + 1}">
            </td>
            <td>
                Destination
                <select class="form-control select2 destination" name="destination[${rowIndex}]">
                    <option value="">Select Destination</option>
                    @foreach ($destinations as $des)
                        <option value="{{ $des->id }}">{{ $des->title }}</option>
                    @endforeach
                </select>
            </td>
            <td>
                <div class="activity-list"></div> <!-- Activity checkboxes will be appended here -->
            </td>
               <td>
                  <textarea class="form-control"  name="note[${rowIndex}]"  row="20" id=""></textarea>
            </td>
            <td>
                <input class="form-control" type="text" name="hotel[${rowIndex}]">
                <br>
                  <select class="form-control mt-2" name="basis[${rowIndex}]">
                                                                <option value="">Select Basis</option>
                                                                <option value="Bed & Breakfast Basis">Bed & Breakfast Basis</option>
                                                                <option value="Half Board Basis (Breakfast & Dinner)">Half Board Basis (Breakfast & Dinner)</option>
                                                                <option value="Full Board Basis (All 3 Meals)">Full Board Basis (All 3 Meals)</option>
                                                                <option value="Breakfast + Complimentary Dinner">Breakfast + Complimentary Dinner</option>
                                                            </select>
            </td>
            <td>
              <button type="button" class="btn btn-danger remove-row">Remove</button> <button type="button" class="btn btn-success add-row">Add
                                                                Row</button>
            </td>
        </tr>`;

                $("#dynamic-table tbody").append(newRow);
                rowIndex++;

                // Reinitialize Select2 for new row
                $(".select2").select2();
            });

            // Remove row
            $(document).on("click", ".remove-row", function() {
                $(this).closest("tr").remove();
            });
        });
    </script>



    <script>
        $(document).ready(function() {

            var formSubmitted = false;


            $('#myForm').submit(function(event) {

                if (formSubmitted) {

                    event.preventDefault();

                } else {

                    formSubmitted = true;

                    $('#submitBtn').attr('disabled', true);
                }
            });
        });
    </script>
@endsection
