@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Quotation</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Quotation</a>
                                    </li>
                                    <li class="breadcrumb-item active">Quotation Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Quotation list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Id</th>
                                         
                                            <th>Create Date</th>
                                          
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data as $data)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $data->created_at }}</td>
                                         
                                               
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('quotation.edit', $data->id) }}"
                                                        role="button">Edit</a>
                                                 

                                                      
                                                    
                                              


                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
