@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Destination Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Destination</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Destination</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Add Destination</h4>

                                <form action="/insert-destination" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" Destination Name"
                                                name="name" required>
                                        </div>
                                    </div>



                                    {{-- <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Main
                                            Image</label>
                                        <div class="col-sm-10">
                                            <input type="file" required accept="image/*" name="mainimage">
                                        </div>
                                    </div> --}}






                                    {{-- <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Body</label>
                                        <div class="col-sm-10">
                                            <textarea class="summernote" name="summernote" required></textarea>
                                        </div>
                                    </div> --}}






                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                </form>

                            </div>


                            <table style="margin-top: 50px;" id="mainTable" class="table table-striped mb-0 table-editable">
                                <thead>
                                    <tr>
                                        <th>Id</th>

                                        <th>Destinations</th>
                                        <td>Action</td>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($dests as $dest)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $dest->title }}</td>

                                            <td><a class="btn btn-success edit"
                                                    href="{{ route('destination-edit', $dest->id) }}"
                                                    role="button">Edit</a>
                                                {{-- <a class="btn btn-danger delete"
                                                    href="{{ route('destination-delete', $dest->id) }}"
                                                    role="button">Delete</a> --}}
                                            </td>
                                        </tr>
                                    @endforeach


                                </tbody>

                            </table>
                            <div style="margin-top:50px;" class="d-flex justify-content-center">
                                {{ $dests->links() }}
                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
    @endsection
