@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Loyalty</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Loyalty</a>
                                    </li>
                                    <li class="breadcrumb-item active">Loyalty Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Loyalty list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Id</th>

                                            <th>Loyalty</th>

                                            <th>Point</th>
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($data as $data)
                                            <tr>
                                                <td>{{ $data->id }}</td>
                                                <td>{{ \App\Models\Client::where('id', $data->client_id)->first()->name }}
                                                </td>


                                                <td>{{ $data->point }}</td>
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('claim-approve', $data->id) }}"
                                                        role="button">Approve</a>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('claim.disapprove', $data->id) }}"
                                                        role="button">Disapprove</a>

                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
