@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Add Drivers</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Drivers</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Drivers</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->



                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <ul class="list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li> {{ $error }} </li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Add Drivers</h4>

                                <form action="/driver-add" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="name"
                                                required>
                                        </div>
                                    </div>



                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="email"
                                                required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Phone</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="phone"
                                                required>
                                            <small>Please add with country code (+94)</small>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Password</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="password" placeholder=" " name="password"
                                                required>

                                        </div>
                                    </div>



                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-sm-2 col-form-label"> Comfirm
                                            Password</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="password" placeholder=" "
                                                name="password_confirmation" required>
                                        </div>
                                    </div>



                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <a href="{{ url()->previous() }}" type="reset"
                                                class="btn btn-secondary waves-effect m-l-5">
                                                Back
                                            </a>
                                        </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                var i = 0; // Declare and initialize i
                $("#addRow").click(function(event) {
                    event.preventDefault();
                    i++; // Increment i
                    var newRow = '<tr>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][day]"></td>' +
                        '<td><input type="text" class="form-control" name="inputfilde[' + i +
                        '][title]"></td>' +
                        '<td>  <textarea  name="inputfilde[' + i +
                        '][description]" class="form-control" id="" cols="50" rows="1"></textarea></td>' +
                        '<td><button class="deleteRow btn btn-danger">Delete</button></td>' +
                        '</tr>';
                    $("#qaTable tbody").append(newRow);
                    console.log(i);
                });

                $(document).on("click", ".deleteRow", function() {
                    $(this).closest("tr").remove();
                });

            });
        </script>
    @endsection
