@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Client itinerary list</h4>

                                <table id="mainTable" class="table table-striped mb-0 table-editable">
                                    <thead>
                                        <tr>
                                            <th>Id</th>

                                     
                                            <th>Assigned date</th>
                                            <th>Job Invoice</th>
                                      
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($jobs as $data)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                      
                                                <td>{{ $data->created_at }}</td>
                                                
                                                <td>  {{ \App\Models\TourBooking::where('id', $data->tourbid)->first()->invoice ?? '' }}

                                                   </td>
                                                {{-- <td>{{$data->id}}</td> --}}
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('driver-done', $data->id) }}"
                                                        role="button"> Done</a>
                                                        <a class="btn btn-danger edit"
                                                        href="{{ route('driver-cancel', $data->id) }}"
                                                        role="button"> Cancle</a>
                                                        
                                                    </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>
                                
                               

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
