@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <style>
        div#datatable-buttons_filter {
            text-align: end;
        }
    </style>
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Manage Client</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Client</a>
                                    </li>
                                    <li class="breadcrumb-item active">Client Manage</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif


                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">Client list</h4>

                                <table id="datatable-buttons"
                                    class="table table-striped table-bordered dt-responsive nowrap"
                                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Id</th>

                                            <th>Client</th>
                                            <th>Email</th>
                                            <th>Point</th>
                                            <td>Action</td>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data as $data)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $data->name }}</td>
                                                <td>{{ $data->email }}</td>
                                                <td>{{ $data->points }}</td>
                                                <td>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('user-tour-list', $data->id) }}"
                                                        role="button">Itinerary List</a>
                                                    <a class="btn btn-success edit"
                                                        href="{{ route('tour-itinerary', $data->id) }}" role="button">New
                                                        Itinerary</a>

                                                    <a class="btn btn-warning edit"
                                                        href="{{ route('quotation', $data->id) }}" role="button">New
                                                        Quotation</a>
                                                    <a class="btn btn-warning edit"
                                                        href="{{ route('quotation.list', $data->id) }}"
                                                        role="button">Previous
                                                        Quotation</a>
                                                    <a class="btn btn-danger "
                                                        href="{{ route('client-delete', $data->id) }}"
                                                        onclick="return confirm('Are you sure you want to delete this client?')"
                                                        role="button"> Delete Client</a>


                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    @endsection
