<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('safari_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('safari_id');
            $table->foreign('safari_id')->references('id')->on('safaris')->onDelete('cascade');
            $table->string('files')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('safari_images');
    }
};
