<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AuthenticateDriver
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if the user is authenticated with the 'client' guard
        if (Auth::guard('driveruser')->check()) {
            return $next($request); // User is authenticated, proceed to the next request
        }else {
            return redirect('/driver/driver-login'); 
        }

        
       
    }
}
