<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Driver;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB; 
use Carbon\Carbon; 
use App\Models\User; 
use Mail; 
use Hash;
use Illuminate\Support\Str;

class DriverForgotPasswordController extends Controller
{
    
        
        public function showForgetPasswordForm()
        {
           return view('auth.driverforgetPassword');
        }
    
        
        public function submitForgetPasswordForm(Request $request)
        {
            // dd($request->all());
            $request->validate([
                'email' => 'required|email|exists:drivers',
            ]);
    
            $token = Str::random(64);
    
            DB::table('password_reset_tokens')->insert([
                'email' => $request->email, 
                'token' => $token, 
                'created_at' => Carbon::now()
              ]);
    
            Mail::send('emails.driverforgetPassword', ['token' => $token], function($message) use($request){
                $message->to($request->email);
                $message->subject('Reset Password');
            });
    
            return back()->with('message', 'We have e-mailed your password reset link!');
        }
        
        public function showResetPasswordForm($token) { 
           return view('auth.driverforgetPasswordLink', ['token' => $token]);
        }
    
        
        public function submitResetPasswordForm(Request $request)
        {
            $request->validate([
                'email' => 'required|email|exists:drivers',
                'password' => 'required|string|min:6|confirmed',
                'password_confirmation' => 'required'
            ]);
    
            $updatePassword = DB::table('password_reset_tokens')
                                ->where([
                                  'email' => $request->email, 
                                  'token' => $request->token
                                ])
                                ->first();
    
            if(!$updatePassword){
                return back()->withInput()->with('error', 'Invalid token!');
            }
    
            $user = Driver::where('email', $request->email)
                        ->update(['password' => Hash::make($request->password)]);
   
            DB::table('password_reset_tokens')->where(['email'=> $request->email])->delete();
    
            return redirect('/')->with('message', 'Your password has been changed!');
        }
}
