<?php

namespace App\Http\Controllers;

use App\Models\Claim;
use App\Models\Client;
use App\Models\FinishedTours;
use App\Models\HotelBooking;
use App\Models\TourBooking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClientController extends Controller
{
    public function  clientlogin()
    {
        return view('auth.client-login');
    }

    public function login(Request $request)
{
    $credentials = $request->only('email', 'password');
    if (Auth::guard('client')->attempt($credentials)) {
      
        return redirect('/client/client-dashbord'); 
    } else {
      
        return back()->withInput()->withErrors(['email' => 'Invalid credentials']);
    }
}

public function clientLogout()
{
    Auth::guard('client')->logout();
    return redirect('/client/client-login'); 
}

public function  client_dashbord()

{
    $id= auth()->guard('client')->user()->id;
    // dd(Auth::id());
    $tours=TourBooking::where('clientid',$id)->get();

    return view('client.client-dashbord',compact('tours'));
}
public function  mytours()

{
    $id= auth()->guard('client')->user()->id;
    $tours=TourBooking::where('clientid',$id)->orderBy('id', 'desc')->get();

    return view('client.mytours',compact('tours'));
}

public function view_itinerary($id)
{
 
    $data=TourBooking::FindorFail($id);

    $hotels=HotelBooking::where('tourb_id',$data->id)->get();

    return view('client.itinerary-view',compact('data','hotels'));
}
public function  point_claim( Request $request)

{
    // dd($request->all());
    if ($request->point== null) {
        
        return back();
    }
 
   $data = new Claim();
   $data->client_id=$request->client;
   $data->point=$request->point;
   $data->status=0;
   $data->save();

  $client= Client::where('id',$request->client)->first();
$client->points=$client->points-$request->point;
  $client->save();
  
   return back();
}
}
