<?php

namespace App\Http\Controllers;

use App\Mail\InvoiceMail;
use App\Mail\TourItinerary;
use App\Models\Claim;
use App\Models\Driver;
use App\Models\Invoice;
use App\Models\Client;
use App\Models\DriverPlan;
use App\Models\FAQ;
use App\Models\FinishedTours;
use App\Models\HotelBooking;
use App\Models\Itinerary;
use App\Models\Lastsection;
use App\Models\News;
use App\Models\Post;
use App\Models\Safari;
use App\Models\SafariImage;
use App\Models\TourBooking;
use App\Models\TourPackage;
use App\Models\Vehicle;
use App\Models\VehicleCategory;
use App\Models\WhaleWatching;
use App\Models\WhaleWatchingImage;
use App\Models\Youtubevideo;
use Illuminate\Http\Request;
use App\Models\Destination;
use App\Models\Des_image;
use App\Models\Hotel;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Models\CruiseTour;
use App\Models\PostCategory;

use App\Models\CruiseDesImage;
use App\Models\CruiseDestination;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Validation\Rule;

use App\Models\Activity;
use App\Models\Quotation;
use App\Models\QuotationActivity;
use App\Models\QuotationRow;
use App\Mail\QuotationMail;

class AdminController extends Controller
{

    public function  admin()
    {
        return redirect()->route('tour-list');
    }
    public function  destination()
    {
        $dest = Destination::all();
        return view('admin.admin', compact('dest'));
    }
    public function  newDestination()
    {
        $dests = Destination::orderBy('id', 'desc')->paginate(5);
        return view('admin.newdestination', compact('dests'));
    }
    public function  insertdestination(Request $request)
    {


        $data = new Destination();
       
        // $thumbnail = $request->mainimage;
        // $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        // $request->mainimage->move('thumbnails', $imagename);

        $slug = Str::slug($request->name, '-');
        $data->title = $request->name;

        $data->slug = $slug;
        // $data->shdescription = $request->shdescription;

        // $data->thumbnail = $imagename;
        // $data->description = $request->summernote;
        // $data->files = $files;
        $data->save();

        //dd($thumbnail);

        // $i = 0;
        // foreach ($request->file('images') as $thumbnail) {

        //     $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
        //     $thumbnail->move('thumbnails', $image);


        //     $new = new Des_image();
        //     $new->files = $image;
        //     $new->destination_id = $data->id;
        //     $new->save();

        //     $i++;
        // }



        // alert()->success('SuccessAlert','Data Added Successfully!');
        return back()->with('success', 'Destination Added Successfully!');
    }

    public function destdelete($id)
    {
        Destination::findorfail($id)->delete();


        return redirect('/admin')->with('message', 'Post removed.');
    }

    public function  destedit($id)
    {
        $dest = Destination::findOrfail($id);
        $data = DB::table('des_images')->where("destination_id", $id)->get();
        return view('admin.destination-edit', compact('dest', 'data'));
    }

    public function  des_imagedelete($id)
    {

        DB::table('des_images')->where("id", $id)->delete();
        return back();
    }




    public function  destupdate($id, Request $request)
    {



        $data = Destination::findorfail($id);


        // if ($request->hasFile('mainimage')) {
        //     $thumbnail = $request->mainimage;
        //     $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        //     $request->mainimage->move('thumbnails', $imagename);
        //     $data->thumbnail = $imagename;
        // } else {
        //     unset($data['thumbnail']);
        // }

        $slug = Str::slug($request->name, '-');
        $data->title = $request->name;

        $data->slug = $slug;
        // $data->shdescription = $request->shdescription;

        // $data->description = $request->summernote;
        // $data->files = $files;
        $data->save();


        //   multipleimage 

        // if ($request->hasFile('images')) {

        //     $i = 0;
        //     foreach ($request->file('images') as $thumbnail) {

        //         $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
        //         $thumbnail->move('thumbnails', $image);


        //         $new = new Des_image();
        //         $new->files = $image;
        //         $new->destination_id = $data->id;
        //         $new->save();

        //         $i++;
        //     }
        // } else {
        //     $new = new Des_image();
        //     unset($new['image']);
        // }



        return back()->with('success', 'Destination Updaed Successfully!');
        // alert()->success('SuccessAlert','Data Updaed Successfully!');
        // return redirect('/admin');
    }
    public function  new_hotel()
    {

        return view('admin.newhotel');
    }
    public function  inserthotel(Request $request)
    {

        // dd($request->all());

        $data = new Hotel();
        $thumbnail = $request->mainimage;
        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);
        $data->thumbnail = $imagename;

        $data->title = $request->name;
        $data->location = $request->location;

        $data->price = $request->price;
        $data->stars = $request->stars;
        $data->rooms = $request->rooms;



        $data->description = $request->body;

        $data->save();



        alert()->success('SuccessAlert','Data Added Successfully!');

        return redirect()->route('admin');
    }

    public function  hotel_list()
    {
        $data = Hotel::all();
        return view('admin.hotel-list', compact('data'));
    }

    public function hoteldelete($id)
    {
        Hotel::findorfail($id)->delete();


        return redirect('/admin')->with('message', 'Post removed.');
    }

    public function  hoteledit($id)
    {
        $data = Hotel::findOrfail($id);

        return view('admin.hotel-edit', compact('data'));
    }

    public function  hotelupdate($id, Request $request)
    {

        // dd($request->all());

        $data = Hotel::findorfail($id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }

        $data->title = $request->name;


        $data->price = $request->price;
        $data->stars = $request->stars;
        $data->rooms = $request->rooms;
        $data->location = $request->location;


        $data->description = $request->body;

        $data->save();




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect()->route('admin');
    }

    public function  cordelia_cruises()
    {
        $data = CruiseTour::all();
        return view('admin.cruise', compact('data'));
    }
    public function  cruiseedit($id)
    {
        $data = CruiseTour::findOrfail($id);

        return view('admin.cruise-edit', compact('data'));
    }

    public function  cordeliacruises_update($id, Request $request)
    {

        // dd($request->all());

        $data = CruiseTour::findorfail($id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }

        $data->title = $request->name;


        $data->price = $request->price;



        $data->description = $request->description;

        $data->save();




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect()->route('cruise.list');
    }

    public function addtour($id)
    {

        $id = $id;
        return view('admin.add-tours', compact('id'));
    }



    public function  insert_tour(Request $request)
    {

        //  dd($request->all());

        $data = new CruiseDestination();


        $data->tour_id = $request->tour_id;
        $data->title = $request->name;
        $data->description = $request->summernote;


        $data->save();

        $i = 0;
        foreach ($request->file('image') as $thumbnail) {

            $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
            $thumbnail->move('thumbnails', $image);


            $new = new CruiseDesImage();
            $new->image = $image;
            $new->des_id = $data->id;
            $new->save();

            $i++;
        }












        alert()->success('SuccessAlert','Data Insert Successfully!');
        return redirect()->route('cruise.list');
    }

    public function  cruise_des($id)
    {
        $data = CruiseDestination::where('tour_id', $id)->get();
        return view('admin.cruise-des', compact('data'));
    }
    public function  cruise_desedit($id)
    {
        $data = CruiseDestination::findOrFail($id);
        return view('admin.cruise-des-edit', compact('data'));
    }

    public function  cruise_desdelete($id)
    {
        // dd($id);
        $data = CruiseDestination::findOrFail($id);
        $data->delete();
        return redirect()->back();
    }

    public function  cruise_desupdate(Request $request)
    {

        //  dd($request->all());

        $data =  CruiseDestination::findOrfail($request->id);
        // dd($data);


        $data->title = $request->name;
        $data->description = $request->summernote;


        $data->save();

        if ($request->hasFile('image')) {
            $i = 0;
            foreach ($request->file('image') as $thumbnail) {

                $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
                $thumbnail->move('thumbnails', $image);


                $new = new CruiseDesImage();
                $new->image = $image;
                $new->des_id = $data->id;
                $new->save();

                $i++;
            }
        }


        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect()->route('cruise.list');
    }

    function desimg_delete($id)
    {

        CruiseDesImage::where('id', $id)->delete();

        return redirect()->back();
    }

    public function  insert_post(Request $request)
    {

        //  dd($request->all());

        $data = new Post();
        $thumbnail = $request->mainimage;
        $slug = Str::slug($request->title, '-');
        $data->slug = $slug;

        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);
        $data->thumbnail = $imagename;
        $data->cate_id =  $request->cate_id;
        $data->shdescription = $request->shdescription;
        $data->title = $request->title;
        $data->description = $request->description;

        $data->save();

        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }

    public function blog()
    {

        $data = Post::all();

        return view('admin.blog', compact('data'));
    }
    public function postdelete($id)
    {
        Post::findorfail($id)->delete();


        return redirect()->back();
    }

    public function  postedit($id)
    {
        $data = Post::findOrfail($id);
        $category = PostCategory::all();
        return view('admin.post-edit', compact('data', 'category'));
    }

    public function  postupdate(Request $request)
    {

        // dd($request->all());

        $data = Post::findorfail($request->id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }


        $data->title = $request->title;
        $slug = Str::slug($request->title, '-');
        $data->slug = $slug;
        $data->cate_id =  $request->cate_id;
        $data->shdescription = $request->shdescription;
        $data->description = $request->description;

        $data->save();




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect()->back();
    }
    public function  lastedit()
    {
        $data = Lastsection::findOrfail(1);

        return view('admin.last', compact('data'));
    }
    public function  lastsection(Request $request)
    {

        $data = Lastsection::findorfail(1);
        $data->description = $request->description;
        $data->save();

        return redirect()->back();
    }
    public function new_post()
    {

        $category = PostCategory::all();


        return view('admin.newpost', compact('category'));
    }


    //news
    public function  insert_news(Request $request)
    {

        //  dd($request->all());

        $data = new News();
        $thumbnail = $request->mainimage;
        $slug = Str::slug($request->title, '-');
        $data->slug = $slug;

        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);

        $data->thumbnail = $imagename;
        $data->shdescription = $request->shdescription;
        $data->title = $request->title;
        $data->description = $request->description;

        $data->save();

        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }

    public function news()
    {

        $data = News::all();

        return view('admin.news', compact('data'));
    }
    public function newsdelete($id)
    {
        News::findorfail($id)->delete();


        return redirect()->back();
    }

    public function  newsedit($id)
    {
        $data = News::findOrfail($id);


        return view('admin.news-edit', compact('data'));
    }

    public function  newsupdate(Request $request)
    {

        // dd($request->all());

        $data = News::findorfail($request->id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }


        $data->title = $request->title;
        $slug = Str::slug($request->title, '-');
        $data->slug = $slug;
        $data->shdescription = $request->shdescription;
        $data->description = $request->description;

        $data->save();




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect()->back();
    }
    public function new_news()
    {

        return view('admin.new-news');
    }
    public function faq()
    {

        $faq = FAQ::all();
        return view('admin.faq', compact('faq'));
    }

    public function faqupadate(Request $request)
    {

        FAQ::truncate();
        foreach ($request->inputfilde as $key => $value) {

            $faq = new FAQ();
            $faq->question = $value['question'];
            $faq->answer = $value['answer'];
            $faq->save();
        }

        alert()->success('SuccessAlert','Data Updated Successfully!');
        return back();
    }

    public function vehiclerent()
    {

        $categories =  VehicleCategory::all();
        return view('admin.newvehiclerent', compact('categories'));
    }
    public function vehicle_list()
    {

        $data =  Vehicle::all();
        return view('admin.vehicle-list', compact('data'));
    }

    public function edit_vehicle($id)
    {

        $data = Vehicle::where('id', $id)->first();


        $categories =  VehicleCategory::all();
        return view('admin.vehicle-edit', compact('data', 'categories'));
    }

    public function  vehiclerentinsert(Request $request)
    {

        //  dd($request->all());

        $data = new Vehicle();
        $thumbnail = $request->mainimage;


        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);

        $data->image = $imagename;

        $data->vehi_cate = $request->category;

        $slug = Str::slug($request->name, '-');
        $data->slug = $slug;

        $data->name = $request->name;
        $data->pax = $request->pax;
        $data->discount = $request->discount;
        $data->description = $request->description;
        $data->save();

        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }
    public function  updatevehicle($id, Request $request)
    {



        $data =  Vehicle::findorfail($id);;
        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->image = $imagename;
        } else {
            unset($data['image']);
        }

        $data->vehi_cate = $request->category;
        $data->name = $request->name;
        $data->pax = $request->pax;
        $slug = Str::slug($request->name, '-');
        $data->slug = $slug;
        $data->discount = $request->discount;
        $data->description = $request->description;

        $data->save();

        alert()->success('SuccessAlert','Data Updated Successfully!');
        return back();
    }

    public function vehicledelete($id)
    {
        Vehicle::findorfail($id)->delete();


        return back()->with('message', 'Post removed.');
    }
    public function new_safari()
    {



        return view('admin.add-safari');
    }
    public function safari_list()
    {
        $data = Safari::all();


        return view('admin.safari-list', compact('data'));
    }
    public function  insertsafari(Request $request)
    {

        // dd($request->all());

        $data = new Safari();
        $thumbnail = $request->mainimage;
        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);

        $slug = Str::slug($request->title, '-');
        $data->title = $request->title;

        $data->slug = $slug;
        $data->park = $request->park;
        $data->shdescription = $request->shdescription;

        $data->thumbnail = $imagename;
        $data->description = $request->summernote;
        // $data->files = $files;
        $data->save();

        //dd($thumbnail);

        $i = 0;
        foreach ($request->file('images') as $thumbnail) {

            $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
            $thumbnail->move('thumbnails', $image);


            $new = new SafariImage();
            $new->files = $image;
            $new->safari_id = $data->id;
            $new->save();

            $i++;
        }


        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }
    public function edit_safari($id)
    {

        $safari = Safari::where('id', $id)->first();
        // dd($safari);
        $images = SafariImage::where('safari_id', $id)->get();


        return view('admin.edit-safari', compact('safari', 'images'));
    }

    public function  updatesafari($id, Request $request)
    {



        $data = Safari::findorfail($id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }

        $slug = Str::slug($request->title, '-');
        $data->title = $request->title;

        $data->slug = $slug;
        $data->park = $request->park;
        $data->shdescription = $request->shdescription;

        $data->description = $request->summernote;
        // $data->files = $files;
        $data->save();


        //   multipleimage 

        if ($request->hasFile('images')) {

            $i = 0;
            foreach ($request->file('images') as $thumbnail) {

                $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
                $thumbnail->move('thumbnails', $image);


                $new = new SafariImage();
                $new->files = $image;
                $new->safari_id = $id;
                $new->save();

                $i++;
            }
        } else {
            $new = new Des_image();
            unset($new['image']);
        }




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect('/admin');
    }
    public function new_package()
    {



        return view('admin.add-package');
    }
    
 
    public function tour_itinerary($id)
    {

        $data = Client::findOrFail($id);



        return view('admin.tour-itinerary', compact('data'));
    }
    public function quotation($id)
    {

        $data = Client::findOrFail($id);

        $destinations = Destination::all();

        return view('admin.quotation', compact('data','destinations'));
    }
    public function getActivities(Request $request)
    {
        $activities = Activity::where('destination_id', $request->destination_id)->get();
        // dd($activities);
        return response()->json(['activities' => $activities]);
    }
    public function tour_sales($id)
    {

        $data = Client::findOrFail($id);


        return view('admin.tour-sales', compact('data'));
    }
    public function package_list()
    {

        $data = TourPackage::all();

        return view('admin.package-list', compact('data'));
    }

    public function  insert_package(Request $request)
    {

        //   dd($request->all());

        $data = new TourPackage();
        $thumbnail = $request->mainimage;


        $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
        $request->mainimage->move('thumbnails', $imagename);

        $data->thumbnail = $imagename;
        $data->title = $request->name;
        $slug = Str::slug($request->name, '-');
        $data->slug = $slug;
        $data->price = $request->price;
        $data->discount = $request->discount;
        $data->night = $request->night;
        $data->day = $request->night + 1;
        $data->description = $request->description;
        $data->includes = $request->include;
        $data->save();

        foreach ($request->inputfilde as $key => $value) {
            $day = new Itinerary();
            $day->package_id = $data->id;
            $day->day = $value['day'];
            $day->title = $value['title'];
            $day->description = $value['description'];
            $day->save();
        }

        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }

    public function  edit_package($id)
    {
        $data = TourPackage::findOrfail($id);
        $itineray =  Itinerary::where('package_id', $id)->get();

        return view('admin.edit-package', compact('data', 'itineray'));
    }
    public function  update_package($id, Request $request)
    {

        //   dd($request->all());

        $data = TourPackage::findorfail($id);



        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }

        $data->title = $request->name;
        $slug = Str::slug($request->name, '-');
        $data->slug = $slug;
        $data->price = $request->price;
        $data->discount = $request->discount;
        $data->night = $request->night;
        $data->day = $request->night + 1;
        $data->description = $request->description;
        $data->includes = $request->include;
        $data->save();

        Itinerary::where('package_id', $id)->delete();

        foreach ($request->inputfilde as $key => $value) {
            $day = new Itinerary();
            $day->package_id = $id;
            $day->day = $value['day'];
            $day->title = $value['title'];
            $day->description = $value['description'];
            $day->save();
        }

        alert()->success('SuccessAlert','Data Updated Successfully!');
        return back();
    }
    public function package_delete($id)
    {
        TourPackage::findorfail($id)->delete();


        return redirect('/admin')->with('message', 'package removed.');
    }
    public function edit_whale_watching()
    {

        $data = WhaleWatching::where('id', 1)->first();
        //  dd($safari);
        $images = WhaleWatchingImage::all();


        return view('admin.edit-whalewatching', compact('data', 'images'));
    }
    public function  whale_imagedelete($id)
    {

        WhaleWatchingImage::where('id', $id)->delete();
        return back();
    }

    public function  update_whale_watching(Request $request)
    {

        // dd($request->all());

        $data = WhaleWatching::findorfail(1);





        $data->title = $request->title;

        $data->shdescription = $request->shdescription;

        $data->description = $request->summernote;
        // $data->files = $files;
        $data->save();


        //   multipleimage 

        if ($request->hasFile('images')) {

            $i = 0;
            foreach ($request->file('images') as $thumbnail) {

                $image = time() . "$i." . $thumbnail->getClientOriginalExtension();
                $thumbnail->move('thumbnails', $image);


                $new = new WhaleWatchingImage();
                $new->files = $image;
                $new->whale_watchings_id = 1;
                $new->save();

                $i++;
            }
        } else {
            $new = new WhaleWatchingImage();
            unset($new['image']);
        }




        alert()->success('SuccessAlert','Data Updated Successfully!');
        return redirect('/admin');
    }

    public function  complete($id)
    {

        // dd($request->all());

        $data =  TourBooking::findOrFail($id);
        $data->status = '2';
        $data->save();


        $client = Client::findOrFail($data->clientid);
        $percentage = 0.01; // 1% as a decimal
        $newpont = $data->price * $percentage;
        $client->points = $client->points + $newpont;
        $client->save();

        $jobs = DriverPlan::where('tourbid', $id)->first();
        $jobs->status = 2;
        $jobs->save();

        return back();
    }
    // public function  finishedtours(Request $request)
    // {

    //         // dd($request->all());

    //     $data = new FinishedTours();

    //     $data->clientid= $request->clientid;
    //     $data->price = $request->price;
    //     $data->note = $request->note;
    //     // $data->places = $request->places;

    //     $places = explode('^', $request->places); 
    // // dd( $places);
    // $data->places = json_encode($places);
    //     $data->save();

    //    $client= Client::findOrFail($request->clientid);
    //    $percentage = 0.01; // 1% as a decimal
    //    $newpont = $request->price * $percentage;
    //    $client->points = $client->points+$newpont;
    //    $client->save();
    // return back();


    // }

    public function tour_adding(Request $request)
    {
        
    try {
        DB::beginTransaction();
       
 //   dd($request->all());
        // Create a new TourBooking instance and save the basic data
        $data = new TourBooking();
        $data->name = $request->name;
        $data->clientid = $request->clientid;
        $data->email = $request->email;
        // $data->price = $request->price;
        $data->prepaid = $request->prepaid;
        $data->currency= $request->currency;
        $data->deatil = $request->deatil;

        $data->save();

        $days = $request->input('day', []);

        //  dd($request->all());
    
        // Iterate through the days and create HotelBooking records
        foreach ($days as $i => $day) {
            $booking = new HotelBooking();
            $booking->tourb_id = $data->id; // Assuming 'tourb_id' is the foreign key relationship
            $booking->hotel = $request->hotel[$i];
            $booking->date = $request->date[$i];
            $booking->day = $day;
            $booking->h_contact = $request->h_contact[$i];
            $booking->h_address = $request->h_address[$i];
            $booking->h_price = $request->h_price[$i];
            $booking->h_place = $request->h_place[$i];
            $booking->h_note = $request->h_note[$i];
            // $hotel = $hotel + $request->h_price[$i];
            $booking->save();
            $itinerary[] = $request->h_place[$i];
        }
        $tourBooking = TourBooking::findOrFail($data->id);
        $tourBooking->itinerary = json_encode($itinerary);
        $tourBooking->save();

        $lastId = $data->id;
        $randomInvoiceNumber = 'INV' . str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT) . $lastId;
        $data->invoice = $randomInvoiceNumber;

        

        $inrow = $request->input('invoice', []);
        $price=0;
        foreach ($inrow as $j => $row) {
            $invoice = new Invoice();
            $invoice->tourb_id = $data->id; 
            $invoice->detail = $request->invoice[$j]; 
            $invoice->amount = $request->amount[$j]; 
            $invoice->save();
            $price= $price+$request->amount[$j];
        }
      //totaldue
      $sub = $price ;
      $data->subtotal = $sub;
      $data->price = $price;
      $data->total_due = $sub - $request->prepaid;
      $data->save();

        $id = $data->id;
        // $test=Invoice::where('tourb_id',$id)->get();
        //  dd($test->detail);
 
      

        DB::commit();
        // Mail::to($request->email)->send(new TourItinerary($id));
        // Mail::to($request->email)->send(new InvoiceMail($id));
        Mail::to($request->email)->cc('info@lankagetaways.com')->send(new TourItinerary($id));
        Mail::to($request->email)->cc('info@lankagetaways.com')->send(new InvoiceMail($id));
        alert()->success('SuccessAlert', 'Data Insert Successfully!');
        return back();
    } catch (\Exception $e) {
        DB::rollBack();

        // Handle the exception (log, return an error response, etc.)
        Log::error('Error adding tour booking: ' . $e->getMessage());
        return back();
    }
    }
    public function tour_update(Request $request)
    {
        
    try {
       

        DB::beginTransaction();

            // dd($request->id);
         $data =  TourBooking::findorFail($request->id);
         //  dd($data);
         $data->name = $request->name;
         $data->clientid = $request->clientid;
         $data->email = $request->email;
         $data->price = $request->price;
         $data->currency= $request->currency;
         $data->prepaid = $request->prepaid;
       
         $data->deatil = $request->deatil;
         $data->save();
 
         $days = $request->input('day', []);
 
         //  dd($request->all());
 
         $hotel = HotelBooking::where('tourb_id', $request->id)->get();
         foreach ($hotel as $booking) {
             $booking->delete(); // Delete each hotel booking record
         }
         $hotel = 0;
         // Iterate through the days and create HotelBooking records
         foreach ($days as $i => $day) {
             $booking = new HotelBooking();
             $booking->tourb_id = $data->id;
             $booking->hotel = $request->hotel[$i];
             $booking->date = $request->date[$i];
             $booking->day = $day;
             $booking->h_contact = $request->h_contact[$i];
             $booking->h_address = $request->h_address[$i];
             $booking->h_price = $request->h_price[$i];
             $booking->h_place = $request->h_place[$i];
             $booking->h_note = $request->h_note[$i];
             
             $price = (float) $request->h_price[$i];

             // Add to $hotel
             $hotel = $hotel + $price;
             $booking->save();
             $itinerary[] = $request->h_place[$i];
         }
         $tourBooking = TourBooking::findOrFail($data->id);
         $tourBooking->itinerary = json_encode($itinerary);
         $tourBooking->save();
 
      
         $data->invoice = $request->InvoiceNumber;
 
        // delete prvious invoice
      
        $prein = Invoice::where('tourb_id', $request->id)->get();
        foreach ($prein as $pre) {
            $pre->delete(); // Delete each hotel booking record
        }
 //create new invoice
         $inrow = $request->input('invoice', []);
         $price=0;
         foreach ($inrow as $j => $row) {
             $invoice = new Invoice();
             $invoice->tourb_id = $data->id; 
             $invoice->detail = $request->invoice[$j]; 
             $invoice->amount = $request->amount[$j]; 
             $invoice->save();
             $price= $price+$request->amount[$j];
         }
       //totaldue
       $sub = $price ;
       $data->subtotal = $sub;
       $data->price = $price;
       $data->total_due = $sub - $request->prepaid;
       $data->save();
 
         $id = $request->id;
       
        

        DB::commit();

        // Mail::to($request->email)->send(new TourItinerary($id));
        // Mail::to($request->email)->send(new InvoiceMail($id));
         Mail::to($request->email)->cc('info@lankagetaways.com')->send(new InvoiceMail($id));
         alert()->success('SuccessAlert','Data Updated Successfully!');
         return back();
    } catch (\Exception $e) {
        DB::rollBack();

        // Handle the exception (log, return an error response, etc.)
        alert()->error('ErrorAlert', 'An error occurred while processing your request.');
        return back();
    }
    }

    public function client_list()
    {

        $data = Client::all();

        return view('admin.client-list', compact('data'));
    }
    public function clientdelete($id)
    {

       Client::Find($id)->delete();

        return back();
    }
    public function driverdelete($id)
    {

       Driver::Find($id)->delete();

        return back();
    }
      public function driveredit($id)
    {

      $driver= Driver::where('id',$id)->first();

    //   dd($driver);

           return view('admin.driver-edit', compact('driver'));
    }
    protected function driverupdate(Request $request)
    {
  
       $id= $request->id;
        
          $request->validate([
        'name' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'email', 'max:255',Rule::unique('drivers')->ignore($id),],
        'phone' => [
            'required',
            'regex:/^\+94[0-9\s\-\(\)]+$/',
            'min:10',
            Rule::unique('drivers')->ignore($id),
        ],
    ]);
        
        $driver = Driver::find($id);
        // Create a new Driver
        $driver->update([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'phone' => $request->input('phone'),
          
        ]);


        alert()->success('SuccessAlert','Data Updated Successfully!');  
        return redirect()->back();
    }
    // public function tour_list()
    // {

    //     $datas = TourBooking::latest()->get();
    //     // dd($datas);


    //     return view('admin.tour-list', ['datas'=>$datas]);
    // }
     public function tour_list()
    {

        $datas = TourBooking::orderBy('id', 'desc')->paginate(10);

        return view('admin.tour-list', compact('datas'));
    }
    public function usertour_list($id)
    {

        $data = TourBooking::where("clientid", $id)->get();

        return view('admin.usertour-list', compact('data'));
    }
    public function edit_itinerary($id)
    {

        $data = TourBooking::FindorFail($id);

        $places = json_decode($data->itinerary);
        // dd($places);
        $hotels = HotelBooking::where('tourb_id', $data->id)->get();
        $invoicerow=Invoice::where('tourb_id', $data->id)->get();
    return view('admin.tour-itinerary-edit', compact('data', 'hotels', 'places','invoicerow'));
    }

    public function fullpayment($id)
    {

        $data = TourBooking::FindorFail($id);
        $data->total_due = 0;
        $data->save();

        return back();
    }
    public function loyalty()
    {

        $data = Claim::where('status', 0)->get();

        return view('admin.loyalty', compact('data'));
    }
    public function claim_approve($id)
    {

        $data = Claim::where('id', $id)->first();
        $data->status = 1;
        $data->save();
        return back();
    }
    public function claim_disapprove($id)
    {

        $data = Claim::where('id', $id)->first();
        $data->status = 2;
        $data->save();
        return back();
    }

    public function newvideo(){
        return view('admin.newvideo');
    }
    public function  addyoutubevideo(Request $request)
    {

        //  dd($request->all());

        $data = new Youtubevideo();
       
      $data->title = $request->title;
      $data->link = $request->video;
      $data->detail = $request->detail;
        $data->save();

        alert()->success('SuccessAlert','Data Insert Successfully!');
        return back();
    }
    public function youtubevideolist(){
        $data = Youtubevideo::all();
        $portal= Lastsection::Find(2);
        return view('admin.youtubevideolist',compact('data','portal'));
    }
    public function edityoutubevideo($id){
        $data = Youtubevideo::where('id', $id)->first();
        return view('admin.edityoutube',compact('data'));
    }
    public function  updateyoutubevideo(Request $request,$id)
    {

        //  dd($request->all());

        $data =  Youtubevideo::findOrFail($id);
       
      $data->title = $request->title;
      $data->link = $request->video;
      $data->detail = $request->detail;
        $data->save();

        alert()->success('SuccessAlert','Data Updated Successfully!');
        return back();
    }
    public function deleteyoutubevideo($id){
      Youtubevideo::find($id)->delete();
         return back();
    }

    public function  blogcategory()
    {
        $s1 = PostCategory::Find(1);
        $s2 = PostCategory::Find(2);
        $s3 = PostCategory::Find(3);
        return view('admin.blog-category', compact('s1','s2','s3'));
    }
    public function blogcatupdate(Request $request)  {
        
        //  dd($request->all());
      $item=PostCategory::findOrFail($request->id);
      $item->name=$request->name;
      $item->description=$request->data;
      $slug = Str::slug($request->name, '-');
     $item->slug = $slug;

     
      $item->update();
      alert()->success('SuccessAlert','Data Updated Successfully!');
      return back();
          
      }

      public function  portaldescription(Request $request)
      {
  
        // dd($request->all());
          $data = Lastsection::findorfail(2);
          $data->description = $request->description;
          $data->save();
          alert()->success('SuccessAlert','Data Updated Successfully!');
          return redirect()->back();
      }

      public function deletetour($id){
        TourBooking::find($id)->delete();
        return back();
      }
            // Show client registration form
    public function showClientRegistrationForm()
    {
        // dd('yes');
        return view('auth.client-register');
    }

    // Handle client registration
    protected function clintsrore(Request $request)
    {
        // Validation logic for client registration
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:'.Client::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        // Create a new client
        $client = Client::create([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'country' => $request->input('country'),
            'password' => Hash::make($request->input('password')),
        ]);

        // Log in the client after registration (optional)
        auth('client')->login($client);

        alert()->success('SuccessAlert','Client Added Successfully!');
        return redirect(RouteServiceProvider::HOME);
    }


    ///activity
    public function  activity()
    {
        $activities = Activity::orderBy('id', 'desc')->paginate(10);
        return view('admin.activity.activity', compact('activities'));
    }
    public function  newactivity ()
    {
        $dest = Destination::all();
        return view('admin.activity.create-activity',compact('dest'));
    }
    
    public function  insertactivity(Request $request)
    {

       foreach ($request->name as $activityName) {
        $data = new Activity();
        $data->destination_id = $request->dest;
        $data->title = $activityName;
        $data->save();
    }

    return redirect()->back()->with('success', 'Activities added successfully!!');
    }

    public function activitydelete($id)
    {
        Activity::findorfail($id)->delete();


        return redirect('/admin')->with('message', 'Post removed.');
    }

    public function  activityedit($id)
    {
        $act = Activity::findOrfail($id);
        $dests = Destination::where('id',$act->destination_id)->first();
       
        return view('admin.activity.activity-edit', compact('act','dests'));
    }

    public function  activityupdate($id, Request $request)
    {



        $data = Activity::findorfail($id);


        if ($request->hasFile('mainimage')) {
            $thumbnail = $request->mainimage;
            $imagename = time() . "." . $thumbnail->getClientOriginalExtension();
            $request->mainimage->move('thumbnails', $imagename);
            $data->thumbnail = $imagename;
        } else {
            unset($data['thumbnail']);
        }

      
        $data->title = $request->name;
    }


    public function tourQuotation(Request $request)
    {
            //   dd($request->all());
        
    try {
        DB::beginTransaction();
       
 
        $data = new Quotation();
        
        $data->clientid = $request->clientid;
        $data->email = $request->email;
        
        $data->vehicle= $request->vehicle;
        // $data->luxury_vehicle= $request->luxury_vehicle;

        $data->economy_cost= $request->economy_cost;
        $data->luxury_cost= $request->luxury_cost;
        $data->description = $request->detail;
        $data->pre_payment = $request->pre_payment;
        $data->payment_link = $request->payment_link;
        $data->tour_type = $request->packagetype;
        $data->tour_from = $request->from;
        $data->tour_to = $request->to;
        $data->save();

        $days = $request->input('day', []);
        //  dd( $days );   
        if($request->packagetype == 't-package'){

            //  dd( $request->packagetype );
            foreach ($days as $i => $day) {

                // dd( $i );
                $row = new QuotationRow();
                $row->quotations_id = $data->id; 
                $row->destination = $request->destination[$i];
                $row->date = $request->date[$i];
                $row->day = $day;
                $row->hotel = $request->hotel[$i];
                $row->basis  = $request->basis [$i];
                $row->note = $request->note[$i];
                $row->save();

                if (!empty($request->activities[$i])) {
                    foreach ($request->activities[$i] as $activityName) {
                        $activity = new QuotationActivity();
                        $activity->row_id = $row->id; // Link to quotation_row
                        $activity->activity = $activityName;
                        $activity->save();
                    }
                }
                
            }    
            }
     

         DB::commit();
         Mail::to($request->email)->cc('info@lankagetaways.com')->send(new QuotationMail($data->id));
        //    Mail::to($request->email)->send(new QuotationMail($data->id));

         session()->flash('success', 'Data Inserted Successfully!');
        return back();
    } catch (\Exception $e) {
        DB::rollBack();
        Log::error('Error adding tour booking: ' . $e->getMessage());
        session()->flash('error', 'Something went wrong. Please try again.');
        return back();
    }
    }


    public function quotation_edit($id)
    {
        $quotation = Quotation::with('rows.activities')->find($id);

        // dd($quotation);
        $destinations = Destination::all();
    
        return view('admin.quotation-update', compact('quotation', 'destinations'));
    }

   
 public function quotation_update(Request $request, $id)
{
    //   dd($request->all());
      
    try {
        DB::beginTransaction();

        // Retrieve the existing quotation by id
        $data = Quotation::findOrFail($id);

        // Update the main quotation details
        $data->clientid = $request->clientid;
        $data->email = $request->email;
        $data->vehicle = $request->vehicle;
        // $data->luxury_vehicle = $request->luxury_vehicle;
        $data->economy_cost = $request->economy_cost;
        $data->luxury_cost = $request->luxury_cost;
        $data->description = $request->detail;
        $data->pre_payment = $request->pre_payment;
        $data->tour_type = $request->packagetype;
        
        $data->tour_from = $request->from;
        $data->tour_to = $request->to;
        $data->save();
 
        $days = $request->input('day', []);
        //  dd( $days );   
        if($request->packagetype == 't-package'){
       // Update the quotation rows
       $qrows= QuotationRow::where('quotations_id', $request->id)->get();
       // dd($qrows->all());
       foreach ($qrows as $qrow) {
           $qrow->delete(); // Delete each 
       }
            //  dd( $request->packagetype );
            foreach ($days as $i => $day) {

                // dd( $i );
                $row = new QuotationRow();
                $row->quotations_id = $data->id; 
                $row->destination = $request->destination[$i];
                $row->date = $request->date[$i];
                $row->day = $day;
                $row->hotel = $request->hotel[$i];
                $row->basis  = $request->basis [$i];
                $row->note = $request->note[$i];
                $row->save();

                if (!empty($request->activities[$i])) {
                    foreach ($request->activities[$i] as $activityName) {
                        $activity = new QuotationActivity();
                        $activity->row_id = $row->id; // Link to quotation_row
                        $activity->activity = $activityName;
                        $activity->save();
                    }
                }
                
            }    
            }
     

         DB::commit();
 
        //    Mail::to($request->email)->send(new QuotationMail($data->id));
        Mail::to($request->email)->cc('info@lankagetaways.com')->send(new QuotationMail($id));
        
        alert()->success('SuccessAlert', 'Quotation updated successfully!');
        return back();
    } catch (\Exception $e) {
        DB::rollBack();

        // Log the exception
        Log::error('Error updating tour booking: ' . $e->getMessage());
        
        return back()->withErrors('An error occurred while updating the quotation.');
    }
}

public function  quotation_list($id)
{
    $data = Quotation::where('clientid',$id)->get();
    return view('admin.quotation-list', compact('data'));
}
    
}