<?php

namespace App\Providers;

use App\Models\Destination;
use App\Models\FooterSection;
use Illuminate\Support\ServiceProvider;
use App\Models\Safari;
use Illuminate\Pagination\Paginator;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrap();
        view()->composer('*', function ($view) {
            $safarilist = Safari::all();
            $footer=FooterSection::all();
            $topdes=Destination::all();
           

            $view->with('safarilist', $safarilist )->with('footer', $footer )->with('topdes', $topdes );
        }
    );
    }
}
