<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Attendance extends Model
{
    protected $fillable = ['user_id', 'date', 'check_in', 'check_out', 'status'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getHoursWorkedAttribute()
    {
        if ($this->check_in && $this->check_out) {
            return Carbon::parse($this->check_out)->diffInMinutes($this->check_in) / 60;
        }
        return 0;
    }
}