<?php
namespace App\Imports;

use App\Models\Holiday;
use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class MercantileHolidayImport implements OnEachRow, WithHeadingRow
{
    public function onRow(Row $row)
    {
        $row = $row->toArray();

      
        if (!str_contains($row['categories'] ?? '', 'Mercantile')) {
            return;
        }

       
        $rawDate = $row['date'];
        try {
            $parsedDate = \DateTime::createFromFormat('m/d/Y', $rawDate);
            if (!$parsedDate) {

                return;
            }
            $formattedDate = $parsedDate->format('Y-m-d');
        } catch (\Exception $e) {
            return; 
        }

        Holiday::updateOrCreate(
            ['date' => $formattedDate],
            [
                'name' => $row['name'],
                'type' => 'Mercantile',
            ]
        );
    }}