<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Imports\MercantileHolidayImport;
use Maatwebsite\Excel\Facades\Excel;

class HolidayController extends Controller
{
    public function showForm()
    {
        return view('admin.holidays-import');
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xlsx,csv,txt',
        ]);

        Excel::import(new MercantileHolidayImport, $request->file('file'));

        return back()->with('success', 'Mercantile holidays imported successfully!');
    }
}